import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAktivitasPage.dart';
import 'package:absenkuv3/Repository/Model/mAktivitas.dart';
import 'package:absenkuv3/UI/Template/halamanDetailMap.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/verticalDivider.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class CardAktivitas extends StatefulWidget {
  final DataAktivitas dataAktivitas;
  final GlobalKey<ScaffoldState> scaffoldKey;
  final String konteks;
  final PageAktivitasModel redaksional;
  CardAktivitas(this.dataAktivitas, this.scaffoldKey, this.konteks, this.redaksional);

  @override
  _CardAktivitasState createState() => _CardAktivitasState();
}

class _CardAktivitasState extends State<CardAktivitas> {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
          NavigateToDetailAktivitas(context, widget.dataAktivitas.idAktivitas)),
      child: Container(
        decoration: CustomStyle.boxDecoration,
        padding: EdgeInsets.all(14),
        margin: EdgeInsets.only(top: 12, left: 17, right: 17),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              children: [
                Column(
                  children: [
                    Text(widget.dataAktivitas.hari!,
                        style: TextStyle(
                            fontSize: 12,
                            color: Color(0xFF828282),
                            fontWeight: FontWeight.w400)),
                    SizedBox(height: 3),
                    Text(widget.dataAktivitas.tanggal!,
                        style: TextStyle(
                            fontSize: 14, fontWeight: FontWeight.w700)),
                    SizedBox(height: 3),
                    Text(widget.dataAktivitas.bulan!,
                        style: TextStyle(
                            fontSize: 12,
                            color: Color(0xFF828282),
                            fontWeight: FontWeight.w400)),
                  ],
                ),
                VerticalDividerAbsenku(),
                Expanded(
                  child: widget.konteks == 'aktivitasPegawai'
                      ? Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(widget.dataAktivitas.namaKaryawan!,
                                style: TextStyle(
                                    fontSize: 14, fontWeight: FontWeight.w700)),
                            SizedBox(height: 7),
                            Text(
                                "${widget.dataAktivitas.waktu!}  -  ${widget.dataAktivitas.lokasi!}",
                                style: TextStyle(
                                    fontSize: 12,
                                    color: Color(0xFF828282),
                                    fontWeight: FontWeight.w400)),
                          ],
                        )
                      : Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(widget.dataAktivitas.waktu!,
                                style: TextStyle(
                                    fontSize: 14, fontWeight: FontWeight.w700)),
                            SizedBox(height: 7),
                            Text(widget.dataAktivitas.lokasi!,
                                style: TextStyle(
                                    fontSize: 12,
                                    color: Color(0xFF828282),
                                    fontWeight: FontWeight.w400)),
                          ],
                        ),
                ),
              ],
            ),
            SizedBox(
              height: 6,
            ),
            Divider(
              thickness: 1,
            ),
            SizedBox(
              height: 4,
            ),
            Text(widget.redaksional.menuAktivitas!.data!.keterangan!,
                style: TextStyle(
                    color: Color(0xFF828282),
                    fontSize: CustomStyle.fontSizeSmall)),
            SizedBox(height: 6),
            Text(widget.dataAktivitas.keterangan!,
                style: TextStyle(
                    color: CustomStyle.fontColorBlack,
                    fontSize: CustomStyle.fontSizeSmall + 1,
                    fontWeight: FontWeight.w700,
                    overflow: TextOverflow.ellipsis)),
          ],
        ),
      ),
    );
  }

  actionMenu() {
    return {'Detail'}.map((String choice) {
      return PopupMenuItem<String>(
        value: choice,
        child: Text(choice),
      );
    }).toList();
  }
}

class TemplateRow extends StatelessWidget {
  final String title;
  final String? subTitle;
  final Color? color;
  final String? imageUrl;
  final bool titikDua;
  final fontSize;
  final List<int>? flex;
  final String? lat;
  final String? long;
  TemplateRow(this.title, this.subTitle, this.imageUrl, this.color,
      {this.fontSize,
      this.flex,
      this.titikDua = false,
      this.lat = '-',
      this.long = '-'});

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        Expanded(
          flex: flex != null ? flex![0] : 4,
          child: Text(
            title,
            style: TextStyle(
                fontWeight: FontWeight.w600,
                color: color,
                fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
          ),
        ),
        SizedBox(
          width: 12,
        ),
        titikDua
            ? Row(
                children: [
                  SizedBox(
                    width: 12,
                  ),
                  Text(
                    ":",
                    style: TextStyle(
                        color: CustomStyle.fontColorBlack,
                        fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
                  ),
                  SizedBox(
                    width: 12,
                  ),
                ],
              )
            : Container(),
        Expanded(
          flex: flex != null ? flex![1] : 7,
          child: Container(
            color: Colors.white,
            child: Text(
              subTitle!,
              style: TextStyle(
                  color: CustomStyle.fontColorBlack,
                  fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
            ),
          ),
        ),
        SizedBox(
          width: 8,
        ),
        imageUrl != null
            ? Expanded(
                flex: flex != null ? flex![2] : 1,
                child: imageUrl != null
                    ? GestureDetector(
                        onTap: () => BlocProvider.of<NavigatorBloc>(context)
                            .add(NavigateToDetailImageClicked(
                                context, imageUrl)),
                        child: Icon(
                          Icons.image,
                          color: Colors.grey[500],
                          size: 22,
                        ))
                    : Container(),
              )
            : Container(),
        SizedBox(
          width: 8,
        ),
        Expanded(
          flex: 1,
          child: lat != '-' && lat != null
              ? GestureDetector(
                  onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
                      NavigateToDetailMap(
                          context,
                          ModelDetailMap("Lokasi Absen $title",
                              double.parse(lat!), double.parse(long!)))),
                  child: Icon(
                    Icons.pin_drop_rounded,
                    color: Colors.redAccent,
                    size: 21,
                  ))
              : Container(),
        ),
      ],
    );
  }
}
