import 'package:absenkuv3/Bloc/Absensi/DataAbsensiBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Absensi/KomponenAbsensi.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/FilterToggle/UI/templateFilterTogle.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListAbsensiSaya extends StatefulWidget {
  final PageDataAbsensiModel redaksional;
  HalamanListAbsensiSaya(this.redaksional);

  @override
  _HalamanListAbsensiSayaState createState() => _HalamanListAbsensiSayaState();
}

class _HalamanListAbsensiSayaState extends State<HalamanListAbsensiSaya> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    // BlocProvider.of<DataAbsensiBloc>(context)
    //     .add(getListDataAbsensiEvent(context, null));
    BlocProvider.of<DataAbsensiBloc>(context)
        .add(getListDataAbsensiSayaEvent(context, null));
    _scrollController.addListener(() =>
        BlocProvider.of<DataAbsensiBloc>(context)
            .add(loadMoreSayaEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<DataAbsensiBloc, DataAbsensiState>(
              builder: (BuildContext context, DataAbsensiState state) {
            if (state is getListDataAbsensiSayaSuccessState ||
                state is LoadMoreProgressState)
              return Stack(
                children: <Widget>[
                  ListView.builder(
                      physics: AlwaysScrollableScrollPhysics(),
                      controller: _scrollController,
                      itemCount: state.data!.length,
                      itemBuilder: (BuildContext context, index) {
                        return CardAbsensi(
                            state.data![index], widget.redaksional);
                      }),
                  state is LoadMoreProgressState
                      ? Positioned(
                          bottom: 16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(
                                  child: CircularProgressIndicator(
                                strokeWidth: 8,
                              ))))
                      : Container(),
                ],
              );
            else if (state is DataAbsensiProgressState)
              return Center(
                child: CircularProgressIndicator(
                  strokeWidth: 8,
                ),
              );
            else
              return Center(
                child: Image.asset(
                  ValueImage.noData,
                  height: 250,
                ),
              );
          }),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
              listener: (BuildContext context,
                  DateRangePickerState dateRangePickerState) {
                if (dateRangePickerState is DateAvailable)
                  BlocProvider.of<DataAbsensiBloc>(context).add(
                      getListDataAbsensiSayaEvent(context,
                          ModelFilter(dateRange: dateRangePickerState.date)));
              },
              child: TemplateFilterToggle(),
            ),
          ),
        ],
      ),
    );
  }
}
  