import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Absensi/halamanListAbsensiPegawai.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'halamanListAbsensiSaya.dart';

class ParentTabDataAbsensi extends StatelessWidget {
  final int tabLength = 2;
  @override
  Widget build(BuildContext context) {
    return BlocBuilder<AuthBloc, LoginRespon>(
        builder: (BuildContext context, LoginRespon loginRespon) {
      return DefaultTabController(
        length: tabLength,
        child: 
        FutureBuilder<PageDataAbsensiModel>(
          future: PengaturanBahasa().dataAbsensi(),
          builder: (context, snapshot) {
            if(snapshot.connectionState == ConnectionState.done){
              return Scaffold(
                appBar: AppBar(
                  centerTitle: true,
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  title: Text(
                    snapshot.data!.menuDataAbsensi!.title!,
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                  ),
                  bottom: loginRespon.dataLogin!.level != 3
                      ? TabBar(
                          labelPadding: EdgeInsets.all(0),
                          indicatorSize: TabBarIndicatorSize.tab,
                          indicatorWeight: 4,
                          isScrollable: true,
                          tabs: [
                            Container(
                              width: MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: snapshot.data!.menuDataAbsensi!.tabSaya,
                              ),
                            ),
                            Container(
                              width: MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: snapshot.data!.menuDataAbsensi!.tabKaryawan,
                              ),
                            ),
                          ],
                        )
                      : null,
                ),
                body: TabBarView(
                  physics: NeverScrollableScrollPhysics(),
                  children: [
                    HalamanListAbsensiSaya(snapshot.data!),
                    HalamanListAbsensiPegawai(snapshot.data!),
                  ],
                ),
              );
            }else{
              return CircularProgressIndicator(strokeWidth: 8);
            }
          }
        ),
      );
    });
  }
}
