import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import '../Repository/Model/mLogin.dart';
import '../Repository/sharedPreference.dart';

class Header{
  getHeader() async{
    LoginRespon loginRespon = await sharedPreferences().getUserData();
    String bahasa = await sharedPreferences().getBahasa();
    Map<String, String?> headerOptions;
    if(loginRespon.dataLogin == null){
      headerOptions = {
        "api-key": ServerInfo.apiKey,
        "versi-app": ServerInfo.versionName,
        "locale": bahasa,
        "Accept": "application/json"};
      return headerOptions;
    }else{
      headerOptions = {
        "api-key": ServerInfo.apiKey,
        "id-company": loginRespon.dataLogin!.idCompany,
        "id-cabang": loginRespon.dataLogin!.idCabang,
        "id-cabang-arr": null,
        "id-departemen": loginRespon.dataLogin!.idDepartemen,
        "id-departemen-arr": null,
        "level-user": loginRespon.dataLogin!.level.toString(),
        "kantor-pusat": loginRespon.dataLogin!.kantorPusat,
        "id-karyawan": loginRespon.dataLogin!.idKaryawan,
        "versi-app": ServerInfo.versionName,
        "id-klien": loginRespon.dataLogin!.idKlien,
        "koordinator": loginRespon.dataLogin!.koordinator,
        "koordinator-klien": loginRespon.dataLogin!.koordinatorKlien,
        "klien": loginRespon.dataLogin!.klien.toString(),
        "locale": bahasa,
        "Accept": "application/json"};
      return headerOptions;
    }
  }



}
