import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:dio/dio.dart';
import 'serviceInfo.dart';

class SplashScreenApi {
  Dio dio = ServerInfo().getConnection();
  Future<VersionRespon> cekVersion(currentVersion, os) async {
    var respon = await dio.get("cek-version",
        queryParameters: {"versi_mobile": currentVersion, "os": os}, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return versionResponFromJson(respon.data);
    } else {
      return VersionRespon(success: false);
    }
  }
  Future<VersionRespon> cekVersionV2(currentVersion, os, sourceInstaller) async {
    var respon = await dio.get("cek-version-v2",
        queryParameters: {
          "versi_mobile": currentVersion,
          "os": os,
          "source_installer": sourceInstaller
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return versionResponFromJson(respon.data);
    } else {
      return VersionRespon(success: false);
    }
  }

  Future<BasicRespon> versionApp(currentVersionApp) async {
    var respon = await dio.get("version_app",
        queryParameters: {"versi_app": currentVersionApp},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
}
