import 'package:dio/dio.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter_dotenv/flutter_dotenv.dart';
import 'package:pretty_dio_logger/pretty_dio_logger.dart';

class ServerInfo {
  // VERSI APLIKASI
  static const versionName = '1.0.0';
  static const versionCode = 1;
  static const bolehDevelopermod = true;
  static const messageDeveloperMode =
      "Aplikasi ini tidak memperbolehkan developer mode aktif, harap untuk mematikan developer mode";
  static const limit = 12;
  static const apiKey = "absenku123**";
  static const cekSource = true;

  static bool logger = false;

  static final ServerInfo _instance = ServerInfo._internal();
  late Dio _dio;

  factory ServerInfo() {
    return _instance;
  }

  ServerInfo._internal() {
    _initDio();
  }

  void _initDio() {
    _dio = Dio(BaseOptions(
      baseUrl: dotenv.get('NGROK'),
      connectTimeout: const Duration(seconds: 30),
      receiveTimeout: const Duration(seconds: 30),
      contentType: Headers.formUrlEncodedContentType,
      responseType: ResponseType.plain,
    ));

    if (logger && kDebugMode) {
      _dio.interceptors.add(PrettyDioLogger(
        requestHeader: true,
        requestBody: true,
        responseHeader: false,
        responseBody: true,
        error: true,
        compact: true,
        maxWidth: 120,
      ));
    }
  }

  Dio getConnection() => _dio;
  void resetDio() {
    _initDio();
  }
}
