import 'package:absenkuv3/Repository/Model/mPkwt.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:dio/dio.dart';

class PkwtApi {
  Dio dio = ServerInfo().getConnection();

  Future<PkwtRespon> getDataPkwt(konteks) async {
    var respon = await dio.get("pkwt/data",
        queryParameters: {"konteks": konteks},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return pwktResponFromJson(respon.data);
    } else {
      return PkwtRespon(success: false);
    }
  }

  Future<PkwtRespon> getDetailDataPkwt(idPkwt) async {
    var respon = await dio.get("pkwt/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": 0,
          "konteks": 'pkwtDetail',
          "id_pkwt": idPkwt
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return pwktResponFromJson(respon.data);
    } else {
      return PkwtRespon(success: false);
    }
  }
  Future<BasicRespon> tolakPwkt(
      TolakPkwtModel tolakPkwtModel) async {
    Map<String, dynamic> parameters;
    parameters = {
      "id_pkwt":tolakPkwtModel.id_pkwt,
      "ket_tolak":tolakPkwtModel.alasanTolak
    };
    var respon = await dio.patch("pkwt/tolak",
        data: parameters,
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
  Future<BasicRespon> setujuiPkwt(
      SetujuiPkwtModel setujuiPkwt) async {
    Map<String, dynamic> parameters;
    parameters = {
      "id_pkwt":setujuiPkwt.id_pkwt,
      "image":setujuiPkwt.image,
      "no_pkwt":setujuiPkwt.no_pkwt
    };
    var respon = await dio.patch("pkwt/setujui",
        data: parameters,
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
  Future<BadgePkwt> badgePkwt() async {
    var respon = await dio.get("pkwt/badge",
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    print('waaaaw');
    if (respon.statusCode == 200) {
      return badgePkwtFromJson(respon.data);
    } else {
      return BadgePkwt(success: false);
    }
  }
}
