import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mPengumuman.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class PengumumanApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  Dio dio = ServerInfo().getConnection();
  Future<PengumumanRespon> getDataPengumuman(
      offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("pengumuman/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": offset,
          "keywords": modelFilter != null && modelFilter.keywords != null
              ? modelFilter.keywords
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return pengumumanResponFromJson(respon.data);
    } else {
      return PengumumanRespon(success: false);
    }
  }

  Future<PengumumanRespon> getDetailPengumuman(idPengumuman) async {
    var respon = await dio.get("pengumuman/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": 0,
          "id_pengumuman": idPengumuman
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return pengumumanResponFromJson(respon.data);
    } else {
      return PengumumanRespon(success: false);
    }
  }
}
