import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/Core/mGetKomponenAtasan.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiApproval/mDataAspekKedisiplinan.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiApproval/mDataAspekKepribadian.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiApproval/mDataNilaiIndividu.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart'
    as mDataPengajuan;
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpiWithBobot.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mGetDataKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mListKpiTeam.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mPengajuanKpi.dart'
    as mpengajuan;
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class KpiApi {
  final monthYearFormat = new DateFormat('yyyy');
  final dateFormat = new DateFormat('yyyy-MM-dd');
  Dio dio = ServerInfo().getConnection();
  Future<GetKomponenAtasanRespon> getKomponenAtasan() async {
    var respon = await dio.get("kpi/komponenatasan",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return getKomponenAtasanResponFromJson(respon.data);
    } else {
      return GetKomponenAtasanRespon(success: false);
    }
  }

  Future<ResponlistKpi> getListKpi(ModelFilterKpi filter) async {
    var respon = await dio.get("kpi/getDataKpi",
        queryParameters: {"month_year": filter.monthYear},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return responlistKpiFromJson(respon.data);
    } else {
      return ResponlistKpi(success: false);
    }
  }

  Future<BasicRespon> pengajuanKpi(
      mpengajuan.ModelPengajuanKpi modelPengajuanKpi) async {
    var respon = await dio.post("kpi/pengajuanKpi",
        queryParameters: {
          "id_karyawan": modelPengajuanKpi.karyawan,
          "bulan": modelPengajuanKpi.bulan,
          "tahun": modelPengajuanKpi.tahun
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> pengajuanKpiWithDataLampau(
      mpengajuan.ModelPengajuanKpi modelPengajuanKpi) async {
    var respon = await dio.post("kpi/pengajuanKpiWithDataLampau",
        queryParameters: {
          "id_karyawan": modelPengajuanKpi.karyawan,
          "bulan": modelPengajuanKpi.bulan,
          "tahun": modelPengajuanKpi.tahun
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<DataPengajuanKpiWithBobotRespon> getDataPengajuanKpiTeam(
      String? id_karyawan, String? id_company, int? bulan, int? tahun) async {
    var respon = await dio.get("kpi/dataPengajuanTeam",
        queryParameters: {
          "id_karyawan": id_karyawan,
          "id_company": id_company,
          "bulan": bulan,
          "tahun": tahun
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataPengajuanKpiWithBobotResponFromJson(respon.data);
    } else {
      return DataPengajuanKpiWithBobotRespon(success: false);
    }
  }

  Future<BasicRespon> tambahPengajuanIndikator(
      mDataPengajuan.ModelPengajuanPerformanceIndikator model) async {
    var respon = await dio.post("kpi/pengajuanPerformanceIndikator",
        queryParameters: {
          "id_karyawan": model.karyawan,
          "id_company": model.idCompany,
          "bulan": model.bulan,
          "tahun": model.tahun,
          "nm_object": model.nmObject,
          "id_object": model.idObject,
          "no_urut_object": model.noUrutObject,
          "nm_indikator": model.nmIndikator,
          "target": model.target,
          "bobot": model.bobot,
          "poin1": model.poin1,
          "poin2": model.poin2,
          "poin3": model.poin3,
          "poin4": model.poin4,
          "poin5": model.poin5,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> updatePengajuanIndikator(
      mDataPengajuan.ModelPengajuanPerformanceIndikator model) async {
    var respon = await dio.post("kpi/updatePerformanceIndikator",
        queryParameters: {
          "id_pi_trx": model.idPiTrx,
          "id_karyawan": model.karyawan,
          "id_company": model.idCompany,
          "bulan": model.bulan,
          "tahun": model.tahun,
          "nm_object": model.nmObject,
          "id_object": model.idObject,
          "no_urut_object": model.noUrutObject,
          "nm_indikator": model.nmIndikator,
          "target": model.target,
          "bobot": model.bobot,
          "poin1": model.poin1,
          "poin2": model.poin2,
          "poin3": model.poin3,
          "poin4": model.poin4,
          "poin5": model.poin5,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deletePengajuanIndikator(
      mDataPengajuan.ModelPengajuanPerformanceIndikator model) async {
    var respon = await dio.post("kpi/deletePerformanceIndikator",
        queryParameters: {"id_pi_trx": model.idPiTrx},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> publishKpiTeam(
      mDataPengajuan.ParsingModelKaryawan data) async {
    var respon = await dio.patch("kpi/publishKpiTeam",
        queryParameters: {
          "id_karyawan": data.karyawan,
          "id_company": data.id_company,
          "bulan": data.bulan,
          "tahun": data.tahun
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<GetListKpiTeamRespon> getListKpiSaya(ModelFilterKpi filter) async {
    var respon = await dio.get("kpi/listKpiSaya",
        queryParameters: {
          "status": filter.status,
          "month_year": filter.monthYear
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return getListKpiTeamResponFromJson(respon.data);
    } else {
      return GetListKpiTeamRespon(success: false);
    }
  }

  Future<GetListKpiTeamRespon> getListKpiTeam(ModelFilterKpi filter) async {
    var respon = await dio.get("kpi/listKpiTeam",
        queryParameters: {
          "status": filter.status,
          "month_year": filter.monthYear
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return getListKpiTeamResponFromJson(respon.data);
    } else {
      return GetListKpiTeamRespon(success: false);
    }
  }
  Future<DataPengajuanKpiTeamRespon> getDataPengajuanKpiSaya(
      String? id_karyawan, String? id_company, int? bulan, int? tahun) async {
    var respon = await dio.get("kpi/dataPengajuanPerfomanceIndikator",
        queryParameters: {
          "id_karyawan": id_karyawan,
          "id_company": id_company,
          "bulan": bulan,
          "tahun": tahun
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataPengajuanKpiTeamFromJson(respon.data);
    } else {
      return DataPengajuanKpiTeamRespon(success: false);
    }
  }
    Future<BasicRespon> simpanDataPengajuanDraftSaya(
      List<Map<String, dynamic>> listItem,
      mDataPengajuan.ParsingModelKaryawan karyawan) async {
    var respon = await dio.patch(
      "kpi/simpanDraftPengajuanSaya",
      data: {
        "id_karyawan": karyawan.id_karyawan,
        "id_company": karyawan.id_company,
        "bulan": karyawan.bulan,
        "tahun": karyawan.tahun,
        "list": listItem
      }, // Mengirim data dalam format JSON
      options: Options(
        headers: {
          ...await Header().getHeader(),
          'Content-Type':
              'application/json', // Menetapkan Content-Type ke application/json
        },
      ),
    );
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
  Future<BasicRespon> simpanDataPengajuanDraftApproval(
      List<Map<String, dynamic>> listItem,
      mDataPengajuan.ParsingModelKaryawan karyawan) async {
    var respon = await dio.patch(
      "kpi/simpanDraftPengajuanApproval",
      data: {
        "id_karyawan": karyawan.id_karyawan,
        "id_company": karyawan.id_company,
        "bulan": karyawan.bulan,
        "tahun": karyawan.tahun,
        "list": listItem
      }, // Mengirim data dalam format JSON
      options: Options(
        headers: {
          ...await Header().getHeader(),
          'Content-Type':
              'application/json', // Menetapkan Content-Type ke application/json
        },
      ),
    );
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
    Future<BasicRespon> simpanDataPengajuanDraftAspekKepribadian(
      List<Map<String, dynamic>> listItem,
      mDataPengajuan.ParsingModelKaryawan karyawan) async {
    var respon = await dio.patch(
      "kpi/simpanDraftPengajuanAspekKepribadian",
      data: {
        "id_karyawan": karyawan.id_karyawan,
        "id_company": karyawan.id_company,
        "bulan": karyawan.bulan,
        "tahun": karyawan.tahun,
        "list": listItem
      }, // Mengirim data dalam format JSON
      options: Options(
        headers: {
          ...await Header().getHeader(),
          'Content-Type':
              'application/json', // Menetapkan Content-Type ke application/json
        },
      ),
    );
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
    Future<BasicRespon> publishAtasan(List<Map<String, dynamic>> listItem,
      mDataPengajuan.ParsingModelKaryawan dataKaryawan) async {
    var respon = await dio.patch(
      "kpi/publishKeAtasan",
      data: {
        "id_karyawan": dataKaryawan.id_karyawan,
        "id_company": dataKaryawan.id_company,
        "bulan": dataKaryawan.bulan,
        "tahun": dataKaryawan.tahun,
        "list": listItem
      }, // Mengirim data dalam format JSON
      options: Options(
        headers: {
          ...await Header().getHeader(),
          'Content-Type':
              'application/json', // Menetapkan Content-Type ke application/json
        },
      ),
    );
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
  Future<DataPengajuanAspekKepribadian> getDataPengajuanAspekKepribadian(
      mDataPengajuan.ParsingModelKaryawan data) async {
    var respon = await dio.get("kpi/dataPengajuanApsekKepribadian",
        queryParameters: {
          "id_karyawan": data.id_karyawan,
          "id_company": data.id_company,
          "bulan": data.bulan,
          "tahun": data.tahun
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataPengajuanAspekKepribadianFromJson(respon.data);
    } else {
      return DataPengajuanAspekKepribadian(success: false);
    }
  }

  Future<DataPengajuanAspekKepribadian> getDataAspekKepribadian(
      mDataPengajuan.ParsingModelKaryawan data) async {
    var respon = await dio.get("kpi/dataApsekKepribadian",
        queryParameters: {
          "id_karyawan": data.id_karyawan,
          "id_company": data.id_company,
          "bulan": data.bulan,
          "tahun": data.tahun
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataPengajuanAspekKepribadianFromJson(respon.data);
    } else {
      return DataPengajuanAspekKepribadian(success: false);
    }
  }
  Future<DataPengajuanAspekKedisiplinan> getDataPengajuanAspekKedisiplinan(
      mDataPengajuan.ParsingModelKaryawan data) async {
    var respon = await dio.get("kpi/dataPengajuanApsekKedisiplinan",
        queryParameters: {
          "id_karyawan": data.id_karyawan,
          "id_company": data.id_company,
          "bulan": data.bulan,
          "tahun": data.tahun
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataPengajuanAspekKedisiplinanFromJson(respon.data);
    } else {
      return DataPengajuanAspekKedisiplinan(success: false);
    }
  }
  Future<DataPengajuanAspekKedisiplinan> getDataAspekKedisiplinan(
      mDataPengajuan.ParsingModelKaryawan data) async {
    var respon = await dio.get("kpi/dataApsekKedisiplinan",
        queryParameters: {
          "id_karyawan": data.id_karyawan,
          "id_company": data.id_company,
          "bulan": data.bulan,
          "tahun": data.tahun
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataPengajuanAspekKedisiplinanFromJson(respon.data);
    } else {
      return DataPengajuanAspekKedisiplinan(success: false);
    }
  }
Future<DataPengajuanNilaiIndividu> getDataPengajuanNilaiIndividu(
      mDataPengajuan.ParsingModelKaryawan data) async {
    var respon = await dio.get("kpi/dataPengajuanNilaiIndividu",
        queryParameters: {
          "id_karyawan": data.id_karyawan,
          "id_company": data.id_company,
          "bulan": data.bulan,
          "tahun": data.tahun
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataPengajuanNilaiIndividuFromJson(respon.data);
    } else {
      return DataPengajuanNilaiIndividu(success: false);
    }
  }
Future<DataPengajuanNilaiIndividu> getDataNilaiIndividu(
      mDataPengajuan.ParsingModelKaryawan data) async {
    var respon = await dio.get("kpi/dataNilaiIndividu",
        queryParameters: {
          "id_karyawan": data.id_karyawan,
          "id_company": data.id_company,
          "bulan": data.bulan,
          "tahun": data.tahun
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataPengajuanNilaiIndividuFromJson(respon.data);
    } else {
      return DataPengajuanNilaiIndividu(success: false);
    }
  }
  Future<BasicRespon> setujuiApprovalKpi(
      mDataPengajuan.ParsingModelKaryawan karyawan, String role, String carrer) async {
    var respon = await dio.post(
      "kpi/setujuiApprovalKpi",
      queryParameters: {
        "id_karyawan": karyawan.id_karyawan,
        "id_company": karyawan.id_company,
        "bulan": karyawan.bulan,
        "tahun": karyawan.tahun,
        "role": role,
        "carrer": carrer
      }, // Mengirim data dalam format JSON
      options: Options(
        headers: {
          ...await Header().getHeader(),
          'Content-Type':
              'application/json', // Menetapkan Content-Type ke application/json
        },
      ),
    );
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
  Future<BasicRespon> terimaAppovalKpi(
      mDataPengajuan.ParsingModelKaryawan karyawan, String keterangan) async {
    var respon = await dio.post(
      "kpi/terimaApprovalKpi",
      queryParameters: {
        "id_karyawan": karyawan.id_karyawan,
        "id_company": karyawan.id_company,
        "bulan": karyawan.bulan,
        "tahun": karyawan.tahun,
        "keterangan": keterangan,
      }, // Mengirim data dalam format JSON
      options: Options(
        headers: {
          ...await Header().getHeader(),
          'Content-Type':
              'application/json', // Menetapkan Content-Type ke application/json
        },
      ),
    );
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

}
