import 'package:absenkuv3/Repository/Model/MonitorAbsen/mBadgeMonitorAbsen.dart';
import 'package:absenkuv3/Repository/Model/MonitorAbsen/mMonitorAbsen.dart';
import 'package:absenkuv3/Repository/Model/mAbsensi.dart';
import 'package:absenkuv3/Repository/Model/mAktivitas.dart';
import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Model/mListKlien.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';

class KoordinatorApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();

  Future<Listklien> getDataKlien(offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("koordinator/data/klien",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return listklienFromJson(respon.data);
    } else {
      return Listklien(success: false);
    }
  }

  Future<RekapAbsensiRespon> getDataAbsensiKlien(
      ModelFilter? modelFilter, offset, String idKlien) async {
    var respon = await dio.get("koordinator/absensi/data",
        queryParameters: {
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "konteks": 'absensiPegawai',
          "limit": ServerInfo.limit,
          "offset": offset,
          "id_klien": idKlien,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return rekapAbsensiResponFromJson(respon.data);
    } else {
      return RekapAbsensiRespon(success: false, data: null);
    }
  }

  Future<AktivitasRespon> getDataAktivitasKlien(
      offset, ModelFilter? modelFilter, String idKlien) async {
    var respon = await dio.get("koordinator/aktivitas/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": 'aktivitasPegawai',
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "id_klien": idKlien
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return aktivitasResponFromJson(respon.data);
    } else {
      return AktivitasRespon(success: false);
    }
  }

  Future<BadgeMonitorAbsen> badgeMonitorAbsen(String? idKlien) async {
    var respon = await dio.get("koordinator/dashboard-absensi/badge",
        queryParameters: {
          "id_klien": idKlien,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return badgeMonitorAbsenFromJson(respon.data);
    } else {
      return BadgeMonitorAbsen(success: false);
    }
  }

  Future<MonitorabsensiRespon> getDataMonitorAbsen(
      String konteks, $offset, String limit, String idKlien) async {
    var respon = await dio.get("koordinator/dashboard-absensi/data",
        queryParameters: {
          "jenis": konteks,
          "limit": limit,
          "offset": $offset,
          "id_klien": idKlien
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return monitorabsensiFromJson(respon.data);
    } else {
      return MonitorabsensiRespon(success: false);
    }
  }

  Future<IzinRespon> getDataIzin(
      offset, konteks, ModelFilter? modelFilter, String idKlien) async {
    var respon = await dio.get("koordinator/izin/data",
        queryParameters: {
          "id_karyawan_select":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "id_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "id_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": konteks,
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "status": modelFilter != null && modelFilter.status != null
              ? modelFilter.status
              : null,
          "id_klien": idKlien,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return izinResponFromJson(respon.data);
    } else {
      return IzinRespon(success: false);
    }
  }

  Future<IzinRespon> getDataIzinDetail(idIzin, konteks, idKlien) async {
    var respon = await dio.get("koordinator/izin/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": 0,
          "konteks": konteks,
          "id_izin": idIzin,
          "id_klien": idKlien,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return izinResponFromJson(respon.data);
    } else {
      return IzinRespon(success: false);
    }
  }

  Future<JumlahBadge> getDataBadgePerKlien(idKlien) async {
    var respon = await dio.get("koordinator/badge/data-per-klien",
        queryParameters: {
          "id_klien": idKlien,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jumlahBadgeFromJson(respon.data);
    } else {
      return JumlahBadge(success: false);
    }
  }

  Future<JumlahBadge> getDataBadgePerKoordinator() async {
    var respon = await dio.get("koordinator/badge/data-per-koordinator",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jumlahBadgeFromJson(respon.data);
  

  setujuiIzinKlien(String? idIzin) {}  } else {
      return JumlahBadge(success: false);
    }
  }

  Future<BasicRespon> setujuiIzinKlien(String? idIzin) async {
    var respon = await dio.patch("koordinator/izin/setujui/$idIzin",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> MewakiliSetujuiIzinKlien(String? idIzin) async {
    var respon = await dio.patch(
        "koordinator/izin/hrd_mewakili_setujui/$idIzin",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> tolakIzinKlien(String? idIzin) async {
    var respon = await dio.patch("koordinator/izin/tolak/$idIzin",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> MewakiliTolakIzinKlien(String? idIzin) async {
    var respon = await dio.patch("koordinator/izin/hrd_mewakili_tolak/$idIzin",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
}
