import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/mAbsensi.dart';
import 'package:absenkuv3/Repository/Model/mAktivitas.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLaporanKinerja.dart';
import 'package:absenkuv3/Repository/Model/mLembur.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class KlienApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();

  Future<AktivitasRespon> getDataAktivitas(
      offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("aktivitas/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": 'aktivitasSaya',
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return aktivitasResponFromJson(respon.data);
    } else {
      return AktivitasRespon(success: false);
    }
  }

  Future<LaporanKinerjaRespon> getDataLaporanKinerja(
      offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("klien/getDataLaporan",
        queryParameters: {
          "id_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "id_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "id_karyawan_select":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": 'aktivitasPegawai',
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return laporanResponFromJson(respon.data);
    } else {
      return LaporanKinerjaRespon(success: false);
    }
  }

  Future<AktivitasRespon> getDataDetailAktivitas(idAktivitas) async {
    var respon = await dio.get("aktivitas/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": 0,
          "konteks": 'detailAktivitas',
          "id_aktivitas": idAktivitas,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return aktivitasResponFromJson(respon.data);
    } else {
      return AktivitasRespon(success: false);
    }
  }

    Future<RekapAbsensiRespon> getLaporanAbsensiKlien(
      ModelFilter? modelFilter, offset) async {
    // print(
    //   modelFilter != null ? modelFilter.idCabang ?? null : null,
    // );
    // print(
    //   modelFilter != null ? modelFilter.idDepartemen ?? null : null,
    // );
    // print(ServerInfo.limit);
    // print(offset);
    var respon = await dio.get("klien/getDataLaporanAbsensiKlien", queryParameters: {
      "filter_bulan": modelFilter != null && modelFilter.monthYear != null
          ? monthYearFormat.format(modelFilter.monthYear!).toString()
          : null,
      "range_tanggal_mulai":
      modelFilter != null && modelFilter.dateRange != null
          ? dateFormat.format(modelFilter.dateRange![0]).toString()
          : null,
      "range_tanggal_selesai":
      modelFilter != null && modelFilter.dateRange != null
          ? dateFormat.format(modelFilter.dateRange![1]).toString()
          : null,
      "id_departemen":
      modelFilter != null ? modelFilter.idDepartemen ?? null : null,
      "id_cabang": modelFilter != null ? modelFilter.idCabang ?? null : null,
      "id_select_karyawan":
      modelFilter != null ? modelFilter.idPegawai ?? null : null,
      "limit": ServerInfo.limit,
      "offset": offset,
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return rekapAbsensiResponFromJson(respon.data);
    } else {
      return RekapAbsensiRespon(success: false);
    }
  }

  Future<JenisDataRespon> getDataDropdownKlien() async {
    var respon = await dio.get("klien/dataDropdownKlien",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

}
