import 'package:absenkuv3/Repository/Model/mFilterHeader.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';

class FilterApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  Dio dio = ServerInfo().getConnection();

Future<FilterHeader> filterHeader() async {
    var response = await dio.get("filter/getData",
        options: Options(headers: await Header().getHeader()));
    if (response.statusCode == 200) {
      return filterHeaderFromJson(response.data);
    } else {
      return FilterHeader(success: false);
    }
  }
Future<FilterHeader> filterHeaderLembur() async {
    var response = await dio.get("filter/getFilterLembur",
        options: Options(headers: await Header().getHeader()));
    if (response.statusCode == 200) {
      return filterHeaderFromJson(response.data);
    } else {
      return FilterHeader(success: false);
    }
  }
}
