import 'package:absenkuv3/Repository/Model/mDashboardNew.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:dio/dio.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class DashboardApi {
  Dio dio = ServerInfo().getConnection();
  Future<DashboardRespon> getData() async {
    var respon = await dio.get("dashboard/data",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dashboardResponFromJson(respon.data);
    } else {
      return DashboardRespon(success: false);
    }
  }

  Future<SummaryRespon> getDataSummaryDashboard() async {
    var respon = await dio.get("dashboard/summary",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return summaryResponFromJson(respon.data);
    } else {
      return SummaryRespon(success: false);
    }
  }
  Future<SummaryRespon> getSisaCuti() async {
    var respon = await dio.get("dashboard/sisa_cuti",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return summaryResponFromJson(respon.data);
    } else {
      return SummaryRespon(success: false);
    }
  }

  Future<SummaryRespon> getIzin() async {
    var respon = await dio.get("dashboard/izin",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return summaryResponFromJson(respon.data);
    } else {
      return SummaryRespon(success: false);
    }
  }

  Future<SummaryRespon> getHadir() async {
    var respon = await dio.get("dashboard/hadir",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return summaryResponFromJson(respon.data);
    } else {
      return SummaryRespon(success: false);
    }
  }
}
