import 'package:absenkuv3/Repository/Model/mAbsensi.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class AbsensiApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();

  Future<AbsensiHariIniRespon> absensiHariIni(DataAbsensi data) async {
    // print("cek absen");
    // print(data.latitude);
    // print(data.longitude);
    var respon = await dio.get("absensi/cek_absen", queryParameters: {
      "latitude": data.latitude,
      "longitude": data.longitude,
    }, options: Options(headers: await Header().getHeader()));
    // print(respon);
    if (respon.statusCode == 200) {
      // print(respon.data);
      return absensiHariIniResponFromJson(respon.data);
    } else {
      return AbsensiHariIniRespon(status: false);
    }
  }

  //ABSENSI POST
  Future<BasicRespon> absensi(DataAbsensi dataAbsensi) async {
    var respon = await dio.post("absensi/tambah", data: {
      "jenis_absen": dataAbsensi.jenisAbsen,
      "lokasi_kantor": dataAbsensi.lokasiAbsen,
      "latitude": dataAbsensi.latitude,
      "longitude": dataAbsensi.longitude,
      "tipe_absen": dataAbsensi.tipeAbsen,
      "kode_absen": dataAbsensi.kodeAbsen,
      "jam_kerja": dataAbsensi.jamKerja,
      "keterangan_absen": dataAbsensi.keteranganAbsen,
      "image": dataAbsensi.foto,
      "ket_kode": dataAbsensi.ketKodeAbsen,
      "tgl_absensi": dataAbsensi.tglJadwalAbsensi,
      "id_master_shift": dataAbsensi.idMasterShift,
      "shift_sebelumnya":dataAbsensi.shiftSebelumnya ?? '',
      "id_klien":dataAbsensi.idKlien ?? '',
      "nama_klien":dataAbsensi.namaKlien ?? ''
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<RekapAbsensiRespon> getDataAbsensi(
      ModelFilter? modelFilter, offset) async {
    var respon = await dio.get("absensi/data", queryParameters: {
      "range_tanggal_mulai":
          modelFilter != null && modelFilter.dateRange != null
              ? dateFormat.format(modelFilter.dateRange![0]).toString()
              : null,
      "range_tanggal_selesai":
          modelFilter != null && modelFilter.dateRange != null
              ? dateFormat.format(modelFilter.dateRange![1]).toString()
              : null,
      "konteks": 'absensiSaya',
      "limit": ServerInfo.limit,
      "offset": offset,
    }, options: Options(headers: await Header().getHeader()));
    // print(respon);
    if (respon.statusCode == 200) {
      return rekapAbsensiResponFromJson(respon.data);
    } else {
      return RekapAbsensiRespon(success: false, data: null);
    }
  }
  Future<RekapAbsensiRespon> getDataAbsensiSaya(
      ModelFilter? modelFilter, offset) async {
    var respon = await dio.get("absensi/data-absensi-saya", queryParameters: {
      "range_tanggal_mulai":
      modelFilter != null && modelFilter.dateRange != null
          ? dateFormat.format(modelFilter.dateRange![0]).toString()
          : null,
      "range_tanggal_selesai":
      modelFilter != null && modelFilter.dateRange != null
          ? dateFormat.format(modelFilter.dateRange![1]).toString()
          : null,
      "limit": ServerInfo.limit,
      "offset": offset,
    }, options: Options(headers: await Header().getHeader()));
    // print(respon);
    if (respon.statusCode == 200) {
      return rekapAbsensiResponFromJson(respon.data);
    } else {
      return RekapAbsensiRespon(success: false, data: null);
    }
  }

  Future<RekapAbsensiRespon> getDataAbsensiPegawai(
      ModelFilter? modelFilter, offset) async {
    // print(
    //   modelFilter != null ? modelFilter.idCabang ?? null : null,
    // );
    // print(
    //   modelFilter != null ? modelFilter.idDepartemen ?? null : null,
    // );
    // print(ServerInfo.limit);
    // print(offset);
    var respon = await dio.get("absensi/data", queryParameters: {
      "filter_bulan": modelFilter != null && modelFilter.monthYear != null
          ? monthYearFormat.format(modelFilter.monthYear!).toString()
          : null,
      "range_tanggal_mulai":
          modelFilter != null && modelFilter.dateRange != null
              ? dateFormat.format(modelFilter.dateRange![0]).toString()
              : null,
      "range_tanggal_selesai":
          modelFilter != null && modelFilter.dateRange != null
              ? dateFormat.format(modelFilter.dateRange![1]).toString()
              : null,
      "id_departemen":
          modelFilter != null ? modelFilter.idDepartemen ?? null : null,
      "id_cabang": modelFilter != null ? modelFilter.idCabang ?? null : null,
      "id_select_karyawan":
          modelFilter != null ? modelFilter.idPegawai ?? null : null,
      "limit": ServerInfo.limit,
      "offset": offset,
      "konteks": 'absensiPegawai'
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return rekapAbsensiResponFromJson(respon.data);
    } else {
      return RekapAbsensiRespon(success: false);
    }
  }
  Future<RekapAbsensiRespon> getDataAbsensiKaryawan(
      ModelFilter? modelFilter, offset) async {
    // print(
    //   modelFilter != null ? modelFilter.idCabang ?? null : null,
    // );
    // print(
    //   modelFilter != null ? modelFilter.idDepartemen ?? null : null,
    // );
    // print(ServerInfo.limit);
    // print(offset);
    var respon = await dio.get("absensi/data-absensi-karyawan", queryParameters: {
      "filter_bulan": modelFilter != null && modelFilter.monthYear != null
          ? monthYearFormat.format(modelFilter.monthYear!).toString()
          : null,
      "range_tanggal_mulai":
      modelFilter != null && modelFilter.dateRange != null
          ? dateFormat.format(modelFilter.dateRange![0]).toString()
          : null,
      "range_tanggal_selesai":
      modelFilter != null && modelFilter.dateRange != null
          ? dateFormat.format(modelFilter.dateRange![1]).toString()
          : null,
      "id_departemen":
      modelFilter != null ? modelFilter.idDepartemen ?? null : null,
      "id_cabang": modelFilter != null ? modelFilter.idCabang ?? null : null,
      "id_select_karyawan":
      modelFilter != null ? modelFilter.idPegawai ?? null : null,
      "limit": ServerInfo.limit,
      "offset": offset,
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return rekapAbsensiResponFromJson(respon.data);
    } else {
      return RekapAbsensiRespon(success: false);
    }
  }

  Future<RekapAbsensiRespon> getDataDetailAbsensi(
      ModelFilter? modelFilter, offset, String idKaryawan, String tglAbsen) async {
    var respon = await dio.get("absensi/detail-absensi", queryParameters: {
      "range_tanggal_mulai":
      modelFilter != null && modelFilter.dateRange != null
          ? dateFormat.format(modelFilter.dateRange![0]).toString()
          : null,
      "range_tanggal_selesai":
      modelFilter != null && modelFilter.dateRange != null
          ? dateFormat.format(modelFilter.dateRange![1]).toString()
          : null,
      "id_karyawan_detail": idKaryawan,
      "tgl_absen": tglAbsen,
      "limit": ServerInfo.limit,
      "offset": offset,
    }, options: Options(headers: await Header().getHeader()));
    // print(respon);
    if (respon.statusCode == 200) {
      return rekapAbsensiResponFromJson(respon.data);
    } else {
      return RekapAbsensiRespon(success: false, data: null);
    }
  }
}
