import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mGaji.dart';
import 'package:absenkuv3/Repository/Model/mSlipGaji.dart' as slip;
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class GajiApi {
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();

  Future<GajiRespon> getDataGaji(ModelFilter modelFilter) async {
    var respon = await dio.get("gaji/data",
        queryParameters: {
          // ignore: unnecessary_null_comparison
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
        },
        options: Options(headers: await Header().getHeader()));
    // print(respon);
    if (respon.statusCode == 200) {
      return gajiResponFromJson(respon.data);
    } else {
      return GajiRespon(success: false);
    }
  }

  Future<slip.SlipGajiRespon> getDataSlipGaji(ModelFilter modelFilter) async {
    var respon = await dio.get("gaji/slip",
        queryParameters: {
          // ignore: unnecessary_null_comparison
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
        },
        options: Options(headers: await Header().getHeader()));
    // print(respon);
    if (respon.statusCode == 200) {
      return slip.slipGajiResponFromJson(respon.data);
    } else {
      return slip.SlipGajiRespon(success: false);
    }
  }
}
