import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';

class DropdownAkunApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();

  Future<JenisDataRespon> getJenisHubungan() async {
    var respon = await dio.get("dropdown_akun/jenis_hubungan",
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

  Future<JenisDataRespon> getJenisKelamin() async {
    var respon = await dio.get("dropdown_akun/jenis_kelamin",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

  Future<JenisDataRespon> getJenisAgama() async {
    var respon = await dio.get("dropdown_akun/jenis_agama",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

  Future<JenisDataRespon> getJenisPekerjaan() async {
    var respon = await dio.get("dropdown_akun/jenis_pekerjaan",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

  Future<JenisDataRespon> getJenisStatusPerkawinan() async {
    var respon = await dio.get("dropdown_akun/jenis_status_perkawinan",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

  Future<JenisDataRespon> getJenisStatus() async {
    var respon = await dio.get("dropdown_akun/jenis_status",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

  Future<JenisDataRespon> getJenisPendidikan() async {
    var respon = await dio.get("dropdown_akun/jenis_pendidikan",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

  Future<JenisDataRespon> getJenisJenjang() async {
    var respon = await dio.get("dropdown_akun/jenis_jenjang",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon(success: false);
    }
  }

  Future<JenisDataRespon> getJenisAsalLulusan() async {
    var respon = await dio.get("dropdown_akun/jenis_asallulusan",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon(success: false);
    }
  }

  Future<JenisDataRespon> getJenisProvinsi() async {
    var respon = await dio.get("dropdown_akun/jenis_provinsi",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

  Future<JenisDataRespon> getJenisKota(idProv) async {
    // print("kota bro : $idProv");
    var respon = await dio.get("dropdown_akun/jenis_kota",
        queryParameters: {"id_prov": idProv},
        options: Options(headers: await Header().getHeader()));
    // print("kota bro 1 : ${respon.data}");
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

  Future<JenisDataRespon> getJenisKecamatan(String? idKabupaten) async {
    var respon = await dio.get("dropdown_akun/jenis_kecamatan",
        queryParameters: {"id_kab": idKabupaten},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

  Future<JenisDataRespon> getJenisKelurahan(String? idKecamatan) async {
    var respon = await dio.get("dropdown_akun/jenis_kelurahan",
        queryParameters: {"id_kec": idKecamatan},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }

  Future<JenisDataRespon> getJenisGolonganDarah() async {
    var respon = await dio.get("dropdown_akun/jenis_golongan_darah",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisDataResponFromJson(respon.data);
    } else {
      return JenisDataRespon();
    }
  }
}
