import 'package:absenkuv3/Repository/Model/Akun/PengalamanKerja/mPengalamanKerja.dart';
import 'package:absenkuv3/Repository/Model/Akun/PengalamanKerja/mPengalamanKerjaById.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';

class DataPengalamanKerjaApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();

  Future<DataPengalamanKerjaRespon>
      getDataPengalamanKerjaTerferifikasi() async {
    var respon = await dio.get("data_pengalaman_kerja/data",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataPengalamanKerjaResponFromJson(respon.data);
    } else {
      return DataPengalamanKerjaRespon(success: false);
    }
  }

  Future<DataPengalamanKerjaRespon> getDataPengalamanKerjaPengajuan() async {
    var respon = await dio.get("data_pengalaman_kerja/data-pengajuan",
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataPengalamanKerjaResponFromJson(respon.data);
    } else {
      return DataPengalamanKerjaRespon(success: false);
    }
  }

  Future<DataPengalamanKerjaByIdRespon> getDataPengalamanKerjaPengajuanById(
      idRiwayatPekerjaan, konteks) async {
    var respon = await dio.get("data_pengalaman_kerja/data-pengajuan-by-id",
        queryParameters: {
          "id_riwayat_pekerjaan": idRiwayatPekerjaan,
          "konteks": konteks
        },
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataPengalamanKerjaByIdResponFromJson(respon.data);
    } else {
      return DataPengalamanKerjaByIdRespon(success: false);
    }
  }

  Future<BasicRespon> pengajuanTambahDataPengalamanKerja(
      DataDatapengalamankerja dataDatapengalamankerja,
      List<MultiImagePickerModel>? file) async {
    var respon = await dio.post("data_pengalaman_kerja/tambah",
        data: {
          "nama_perusahaan": dataDatapengalamankerja.namaPerusahaan,
          "jenis_perusahaan": dataDatapengalamankerja.jenisPerusahaan,
          "jabatan": dataDatapengalamankerja.jabatan,
          "kota": dataDatapengalamankerja.kota,
          "provinsi": dataDatapengalamankerja.provinsi,
          "alamat_perusahaan": dataDatapengalamankerja.alamatPerusahaan,
          "tgl_masuk": dataDatapengalamankerja.tglMasuk,
          "tgl_keluar": dataDatapengalamankerja.tglKeluar,
          "alasan_berhenti": dataDatapengalamankerja.alasanBerhenti,
          "file": file == null
              ? null
              : file.length == 0
                  ? null
                  : file[0].base64,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> editPengajuanDataPengalamanKerja(
      DataDatapengalamankerja dataPengalamanKerja,
      List<MultiImagePickerModel>? file) async {
    // print("file 1 ${file}");
    // print("file 2 ${file!.length}");
    var respon = await dio.post("data_pengalaman_kerja/edit-pengajuan",
        data: {
          "id_riwayat_pekerjaan": dataPengalamanKerja.idRiwayatPekerjaan,
          "nama_perusahaan": dataPengalamanKerja.namaPerusahaan,
          "jenis_perusahaan": dataPengalamanKerja.jenisPerusahaan,
          "jabatan": dataPengalamanKerja.jabatan,
          "kota": dataPengalamanKerja.kota,
          "provinsi": dataPengalamanKerja.provinsi,
          "alamat_perusahaan": dataPengalamanKerja.alamatPerusahaan,
          "tgl_masuk": dataPengalamanKerja.tglMasuk,
          "tgl_keluar": dataPengalamanKerja.tglKeluar,
          "alasan_berhenti": dataPengalamanKerja.alasanBerhenti,
          "file": file == null
              ? null
              : file.length == 0
                  ? null
                  : file[0].base64,
          "file_old": dataPengalamanKerja.file,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> editDataPengalamanKerja(
      DataDatapengalamankerja dataPengalamanKerja,
      List<MultiImagePickerModel>? file) async {
    var respon = await dio.post("data_pengalaman_kerja/edit",
        data: {
          "id_riwayat_pekerjaan": dataPengalamanKerja.idRiwayatPekerjaan,
          "nama_perusahaan": dataPengalamanKerja.namaPerusahaan,
          "jenis_perusahaan": dataPengalamanKerja.jenisPerusahaan,
          "jabatan": dataPengalamanKerja.jabatan,
          "kota": dataPengalamanKerja.kota,
          "provinsi": dataPengalamanKerja.provinsi,
          "alamat_perusahaan": dataPengalamanKerja.alamatPerusahaan,
          "tgl_masuk": dataPengalamanKerja.tglMasuk,
          "tgl_keluar": dataPengalamanKerja.tglKeluar,
          "alasan_berhenti": dataPengalamanKerja.alasanBerhenti,
          "file": file == null
              ? null
              : file.length == 0
                  ? null
                  : file[0].base64,
          "file_old": dataPengalamanKerja.file,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deleteDataPengalamanKerja(
      String idPengalamanKerja) async {
    var respon = await dio.delete("data_pengalaman_kerja/delete",
        queryParameters: {"id_riwayat_pekerjaan": idPengalamanKerja},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deletePengajuanDataPengalamanKerja(
      String idRiwayatPekerjaan) async {
    var respon = await dio.delete("data_pengalaman_kerja/delete-pengajuan",
        queryParameters: {"id_riwayat_pekerjaan": idRiwayatPekerjaan},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<DataPengalamanKerjaRespon> getDetailDataPengalamanKerjaById(
      DataNotifikasiAkun data) async {
    var respon = await dio.get("data_pengalaman_kerja/data-detail-by-id",
        queryParameters: {"id": data.id, "konteks": data.jenis},
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataPengalamanKerjaResponFromJson(respon.data);
    } else {
      return DataPengalamanKerjaRespon(success: false);
    }
  }
}
