import 'dart:convert';

SlipGajiRespon slipGajiResponFromJson(String str) => SlipGajiRespon.fromJson(json.decode(str));

String slipGajiResponToJson(SlipGajiRespon data) => json.encode(data.toJson());

class SlipGajiRespon {
  bool? success;
  String? message;
  DataSlipGaji? dataSlipGaji;

  SlipGajiRespon({this.success, this.message, this.dataSlipGaji});

  SlipGajiRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    dataSlipGaji = json['data_slip_gaji'] != null
        ? new DataSlipGaji.fromJson(json['data_slip_gaji'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataSlipGaji != null) {
      data['data_slip_gaji'] = this.dataSlipGaji!.toJson();
    }
    return data;
  }
}

class DataSlipGaji {
  List<Header>? header;
  List<Penerimaan>? penerimaan;
  List<Potongan>? potongan;
  Header? value;
  List<Footer>? footer;
  Download? download;
  double? marginPerKategori;

  DataSlipGaji(
      {this.header, this.penerimaan, this.potongan, this.value, this.footer, this.download, this.marginPerKategori});

  DataSlipGaji.fromJson(Map<String, dynamic> json) {
    if (json['header'] != null) {
      header = <Header>[];
      json['header'].forEach((v) {
        header!.add(new Header.fromJson(v));
      });
    }
    if (json['penerimaan'] != null) {
      penerimaan = <Penerimaan>[];
      json['penerimaan'].forEach((v) {
        penerimaan!.add(new Penerimaan.fromJson(  v));
      });
    }
    if (json['potongan'] != null) {
      potongan = <Potongan>[];
      json['potongan'].forEach((v) {
        potongan!.add(new Potongan.fromJson(v));
      });
    }
    value = json['value'] != null ? new Header.fromJson(json['value']) : null;
    if (json['footer'] != null) {
      footer = <Footer>[];
      json['footer'].forEach((v) {
        footer!.add(new Footer.fromJson(v));
      });
    }
    download = json['download'] != null ? new Download.fromJson(json['download']) : null;
    marginPerKategori = json['margin_per_kategori'] != null ? double.parse(json['margin_per_kategori']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.header != null) {
      data['header'] = this.header!.map((v) => v.toJson()).toList();
    }
    if (this.penerimaan != null) {
      data['penerimaan'] = this.penerimaan!.map((v) => v.toJson()).toList();
    }
    if (this.potongan != null) {
      data['potongan'] = this.potongan!.map((v) => v.toJson()).toList();
    }
    if (this.value != null) {
      data['value'] = this.value!.toJson();
    }
    if (this.footer != null) {
      data['footer'] = this.footer!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Download {
  bool? button;
  String? link;
  String? label;

  Download({this.button, this.link, this.label});

  Download.fromJson(Map<String, dynamic> json) {
    button = json['button'];
    link = json['link'];
    label = json['label'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['button'] = this.button;
    data['link'] = this.link;
    data['label'] = this.label;
    return data;
  }
}

class Header {
  String? title;
  String? subtitle;
  bool? bold;
  double? fontSize;
  bool? line;
  List<Detail>? detail;

  Header({this.title, this.subtitle, this.bold, this.fontSize, this.line, this.detail});

  Header.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    subtitle = json['subtitle'];
    bold = json['bold'];
    fontSize = double.parse(json['font_size']);
    line = json['line'];
    if (json['detail'] != null) {
      detail = <Detail>[];
      json['detail'].forEach((v) {
        detail!.add(new Detail.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['subtitle'] = this.subtitle;
    data['bold'] = this.bold;
    data['font_size'] = this.fontSize;
    data['line'] = this.line;
    if (this.detail != null) {
      data['detail'] = this.detail!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Penerimaan {
  String? title;
  String? subtitle;
  bool? bold;
  double? fontSize;
  bool? line;
  List<Detail>? detail;

  Penerimaan(
      {this.title, this.subtitle, this.bold, this.fontSize, this.line, this.detail});

  Penerimaan.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    subtitle = json['subtitle'];
    bold = json['bold'];
    fontSize = double.parse(json['font_size']);
    line = json['line'];
    if (json['detail'] != null) {
      detail = <Detail>[];
      json['detail'].forEach((v) {
        detail!.add(new Detail.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['subtitle'] = this.subtitle;
    data['bold'] = this.bold;
    data['font_size'] = this.fontSize;
    data['line'] = this.line;
    if (this.detail != null) {
      data['detail'] = this.detail!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Potongan {
  String? title;
  String? subtitle;
  bool? bold;
  double? fontSize;
  bool? line;
  List<Detail>? detail;

  Potongan(
      {this.title, this.subtitle, this.bold, this.fontSize, this.line, this.detail});

  Potongan.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    subtitle = json['subtitle'];
    bold = json['bold'];
    fontSize = double.parse(json['font_size']);
    line = json['line'];
    if (json['detail'] != null) {
      detail = <Detail>[];
      json['detail'].forEach((v) {
        detail!.add(new Detail.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['subtitle'] = this.subtitle;
    data['bold'] = this.bold;
    data['font_size'] = this.fontSize;
    data['line'] = this.line;
    if (this.detail != null) {
      data['detail'] = this.detail!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Detail {
  String? title;
  String? subtitle;
  bool? bold;
  double? fontSize;
  bool? line;
  List<Detail>? detail;

  Detail({this.title, this.subtitle, this.bold, this.fontSize, this.line, this.detail});

  Detail.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    subtitle = json['subtitle'];
    bold = json['bold'];
    fontSize = double.parse(json['font_size']);
    line = json['line'];
    if (json['detail'] != null) {
      detail = <Detail>[];
      json['detail'].forEach((v) {
        detail!.add(new Detail.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['subtitle'] = this.subtitle;
    data['bold'] = this.bold;
    data['font_size'] = this.fontSize;
    data['line'] = this.line;
    if (this.detail != null) {
      data['detail'] = this.detail!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Footer {
  String? title;
  String? subtitle;
  bool? bold;
  double? fontSize;
  bool? line;
  List<Detail>? detail;

  Footer({this.title, this.subtitle, this.bold, this.fontSize, this.line, this.detail});

  Footer.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    subtitle = json['subtitle'];
    bold = json['bold'];
    fontSize = double.parse(json['font_size']);
    line = json['line'];
    if (json['detail'] != null) {
      detail = <Detail>[];
      json['detail'].forEach((v) {
        detail!.add(new Detail.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['subtitle'] = this.subtitle;
    data['bold'] = this.bold;
    data['font_size'] = this.fontSize;
    data['line'] = this.line;
    if (this.detail != null) {
      data['detail'] = this.detail!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}