// To parse this JSON data, do
//
//     final shiftTeman = shiftTemanFromJson(jsonString);

import 'dart:convert';

ShiftTeman shiftTemanFromJson(String str) => ShiftTeman.fromJson(json.decode(str));

String shiftTemanToJson(ShiftTeman data) => json.encode(data.toJson());

class ShiftTeman {
    bool? success;
    String? message;
    List<Datum>? data;

    ShiftTeman({
        this.success,
        this.message,
        this.data,
    });

    factory ShiftTeman.fromJson(Map<String, dynamic> json) => ShiftTeman(
        success: json["success"],
        message: json["message"],
        data: List<Datum>.from(json["data"].map((x) => Datum.fromJson(x))),
    );

    Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": List<dynamic>.from(data!.map((x) => x.toJson())),
    };
}

class Datum {
    String? namaLengkap;
    String?idKaryawan;
    String? nik;
    String? tglShift;
    String? kodeShift;
    String? namaShift;
    String? masuk;
    String? pulang;
    bool? enabled;

    Datum({
      this.idKaryawan,
        this.namaLengkap,
        this.nik,
        this.tglShift,
        this.kodeShift,
        this.namaShift,
        this.masuk,
        this.pulang,
        this.enabled
    });

    factory Datum.fromJson(Map<String, dynamic> json) => Datum(
        namaLengkap: json["nama_lengkap"],
        idKaryawan : json["id_karyawan"],
        nik: json["nik"],
        tglShift: json["tgl_shift"],
        kodeShift: json["kode_shift"],
        namaShift: json["nama_shift"],
        masuk: json["masuk"],
        pulang: json["pulang"],
        enabled: json["enabled"],
    );

    Map<String, dynamic> toJson() => {
        "nama_lengkap": namaLengkap,
        "id_karyawan":idKaryawan,
        "nik": nik,
        "tgl_shift": tglShift,
        "kode_shift": kodeShift,
        "nama_shift": namaShift,
        "masuk": masuk,
        "pulang": pulang,
        "enabled": enabled,
    };
}
