// To parse this JSON data, do
//
//     final pengumumanRespon = pengumumanResponFromJson(jsonString);

import 'dart:convert';

PengumumanRespon pengumumanResponFromJson(String str) => PengumumanRespon.fromJson(json.decode(str));

String pengumumanResponToJson(PengumumanRespon data) => json.encode(data.toJson());

class PengumumanRespon {
  PengumumanRespon({
    this.success,
    this.message,
    this.data,
  });

  bool? success;
  String? message;
  List<DataPengumuman>? data;

  factory PengumumanRespon.fromJson(Map<String, dynamic> json) => PengumumanRespon(
    success: json["success"] == null ? null : json["success"],
    message: json["message"] == null ? null : json["message"],
    data: json["data"] == null ? null : List<DataPengumuman>.from(json["data"].map((x) => DataPengumuman.fromJson(x))),
  );

  Map<String, dynamic> toJson() => {
    "success": success == null ? null : success,
    "message": message == null ? null : message,
    "data": data == null ? null : List<dynamic>.from(data!.map((x) => x.toJson())),
  };
}

class DataPengumuman {
  DataPengumuman({
    this.idPengumuman,
    this.target,
    this.targetId,
    this.judul,
    this.content,
    this.dateCreated,
    this.posting,
    this.tglPosting,
    this.idCompany,
    this.tglInput,
    this.tanggalCreated,
    this.waktuCreated,
  });

  String? idPengumuman;
  String? target;
  String? targetId;
  String? judul;
  String? content;
  DateTime? dateCreated;
  String? posting;
  DateTime? tglPosting;
  String? idCompany;
  DateTime? tglInput;
  String? tanggalCreated;
  String? waktuCreated;

  factory DataPengumuman.fromJson(Map<String, dynamic> json) => DataPengumuman(
    idPengumuman: json["id_pengumuman"] == null ? null : json["id_pengumuman"],
    target: json["target"] == null ? null : json["target"],
    targetId: json["target_id"] == null ? null : json["target_id"],
    judul: json["judul"] == null ? null : json["judul"],
    content: json["content"] == null ? null : json["content"],
    dateCreated: json["date_created"] == null ? null : DateTime.parse(json["date_created"]),
    posting: json["posting"] == null ? null : json["posting"],
    tglPosting: json["tgl_posting"] == null ? null : DateTime.parse(json["tgl_posting"]),
    idCompany: json["id_company"] == null ? null : json["id_company"],
    tglInput: json["tgl_input"] == null ? null : DateTime.parse(json["tgl_input"]),
    tanggalCreated: json["tanggal_created"] == null ? null : json["tanggal_created"],
    waktuCreated: json["waktu_created"] == null ? null : json["waktu_created"],
  );

  Map<String, dynamic> toJson() => {
    "id_pengumuman": idPengumuman == null ? null : idPengumuman,
    "target": target == null ? null : target,
    "target_id": targetId == null ? null : targetId,
    "judul": judul == null ? null : judul,
    "content": content == null ? null : content,
    "date_created": dateCreated == null ? null : dateCreated!.toIso8601String(),
    "posting": posting == null ? null : posting,
    "tgl_posting": tglPosting == null ? null : tglPosting!.toIso8601String(),
    "id_company": idCompany == null ? null : idCompany,
    "tgl_input": tglInput == null ? null : tglInput!.toIso8601String(),
    "tanggal_created": tanggalCreated == null ? null : tanggalCreated,
    "waktu_created": waktuCreated == null ? null : waktuCreated,
  };
}
