// To parse this JSON data, do
//
//     final lemburRespon = lemburResponFromJson(jsonString);

import 'dart:convert';

import 'mAbsensi.dart';

LemburRespon lemburResponFromJson(String str) =>
    LemburRespon.fromJson(json.decode(str));

String lemburResponToJson(LemburRespon data) => json.encode(data.toJson());

class LemburRespon {
  LemburRespon({
    this.success,
    this.message,
    this.data,
  });

  bool? success;
  String? message;
  List<DataLembur>? data;

  factory LemburRespon.fromJson(Map<String, dynamic> json) => LemburRespon(
        success: json["success"] == null ? null : json["success"],
        message: json["message"] == null ? null : json["message"],
        data: json["data"] == null
            ? null
            : List<DataLembur>.from(
                json["data"].map((x) => DataLembur.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success == null ? null : success,
        "message": message == null ? null : message,
        "data": data == null
            ? null
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataLembur {
  DataLembur(
      {this.idLembur,
      this.idLemmulai,
      this.status,
      this.warna,
      this.tglAbsenMasuk,
      this.tglAbsenPulang,
      this.nama,
      this.jabatan,
      this.cabang,
      this.departemen,
      this.ketLemburMasuk,
      this.ketLemburPulang,
      this.jamLembur,
      this.jamMasuk,
      this.jamPulang,
      this.totalJamLembur,
      this.lokasiMasuk,
      this.lokasiPulang,
      this.fotoMasuk,
      this.fotoPulang,
      this.listApproval,
      this.aksi,
      this.aksiBatalkan,
      this.buttonApprovalHrd,
      this.latMulai,
      this.longMulai,
      this.latSelesai,
      this.longSelesai,
      this.firstApproval,
      this.jamMulai,
      this.jamSelesai});

  String? idLembur;
  String? idLemmulai;
  String? status;
  String? warna;
  String? tglAbsenMasuk;
  String? tglAbsenPulang;
  String? nama;
  String? jabatan;
  String? cabang;
  String? departemen;
  String? ketLemburMasuk;
  String? ketLemburPulang;
  String? jamLembur;
  String? jamMasuk;
  String? jamPulang;
  String? totalJamLembur;
  String? lokasiMasuk;
  String? lokasiPulang;
  String? fotoMasuk;
  String? fotoPulang;
  List<ListApproval>? listApproval;
  bool? aksi;
  bool? aksiBatalkan;
  bool? buttonApprovalHrd;
  String? latMulai;
  String? longMulai;
  String? latSelesai;
  String? longSelesai;
  bool? firstApproval;
  String? jamMulai;
  String? jamSelesai;

  factory DataLembur.fromJson(Map<String, dynamic> json) => DataLembur(
        idLembur: json["id_lembur"] == null ? null : json["id_lembur"],
        idLemmulai: json["id_lemmulai"] == null ? null : json["id_lemmulai"],
        status: json["status"] == null ? null : json["status"],
        warna: json["warna"] == null ? null : json["warna"],
        tglAbsenMasuk:
            json["tgl_absen_masuk"] == null ? null : json["tgl_absen_masuk"],
        tglAbsenPulang:
            json["tgl_absen_pulang"] == null ? null : json["tgl_absen_pulang"],
        nama: json["nama"] == null ? null : json["nama"],
        jabatan: json["jabatan"] == null ? null : json["jabatan"],
        cabang: json["cabang"] == null ? null : json["cabang"],
        departemen: json["departemen"] == null ? null : json["departemen"],
        buttonApprovalHrd: json["button_approval_hrd"] == null
            ? null
            : json["button_approval_hrd"],
        ketLemburMasuk:
            json["ket_lembur_masuk"] == null ? null : json["ket_lembur_masuk"],
        ketLemburPulang: json["ket_lembur_pulang"] == null
            ? null
            : json["ket_lembur_pulang"],
        jamLembur: json["jam_lembur"] == null ? null : json["jam_lembur"],
        jamMasuk: json["jam_masuk"] == null ? null : json["jam_masuk"],
        jamPulang: json["jam_pulang"] == null ? null : json["jam_pulang"],
        totalJamLembur:
            json["total_jam_lembur"] == null ? null : json["total_jam_lembur"],
        lokasiMasuk: json["lokasi_masuk"] == null ? null : json["lokasi_masuk"],
        lokasiPulang:
            json["lokasi_pulang"] == null ? null : json["lokasi_pulang"],
        fotoMasuk: json["foto_masuk"] == null ? null : json["foto_masuk"],
        fotoPulang: json["foto_pulang"] == null ? null : json["foto_pulang"],
        listApproval: json["list_approval"] == null
            ? null
            : List<ListApproval>.from(
                json["list_approval"].map((x) => ListApproval.fromJson(x))),
        aksi: json["aksi"] == null ? null : json["aksi"],
        aksiBatalkan:
            json["aksi_batalkan"] == null ? null : json["aksi_batalkan"],
        latMulai: json["lat_mulai"] == null ? null : json["lat_mulai"],
        longMulai: json["long_mulai"] == null ? null : json["long_mulai"],
        latSelesai: json["lat_selesai"] == null ? null : json["lat_selesai"],
        longSelesai: json["long_selesai"] == null ? null : json["long_selesai"],
        firstApproval:
            json["first_approval"] == null ? null : json["first_approval"],
        jamMulai: json["jam_mulai"] == null ? null : json["jam_mulai"],
        jamSelesai: json["jam_selesai"] == null ? null : json["jam_selesai"],
      );

  Map<String, dynamic> toJson() => {
        "id_lembur": idLembur == null ? null : idLembur,
        "id_lemmulai": idLemmulai == null ? null : idLemmulai,
        "status": status == null ? null : status,
        "warna": warna == null ? null : warna,
        "tgl_absen_masuk": tglAbsenMasuk == null ? null : tglAbsenMasuk,
        "tgl_absen_pulang": tglAbsenPulang == null ? null : tglAbsenPulang,
        "nama": nama == null ? null : nama,
        "jabatan": jabatan == null ? null : jabatan,
        "cabang": cabang == null ? null : cabang,
        "departemen": departemen == null ? null : departemen,
        "button_approval_hrd":
            buttonApprovalHrd == null ? null : buttonApprovalHrd,
        "ket_lembur_masuk": ketLemburMasuk == null ? null : ketLemburMasuk,
        "ket_lembur_pulang": ketLemburPulang == null ? null : ketLemburPulang,
        "jam_lembur": jamLembur == null ? null : jamLembur,
        "jam_masuk": jamMasuk == null ? null : jamMasuk,
        "jam_pulang": jamPulang == null ? null : jamPulang,
        "total_jam_lembur": totalJamLembur == null ? null : totalJamLembur,
        "lokasi_masuk": lokasiMasuk == null ? null : lokasiMasuk,
        "lokasi_pulang": lokasiPulang == null ? null : lokasiPulang,
        "foto_masuk": fotoMasuk == null ? null : fotoMasuk,
        "foto_pulang": fotoPulang == null ? null : fotoPulang,
        "list_approval": listApproval == null
            ? null
            : List<dynamic>.from(listApproval!.map((x) => x.toJson())),
        "aksi": aksi == null ? null : aksi,
        "aksi_batalkan": aksiBatalkan == null ? null : aksiBatalkan,
        "first_approval": firstApproval == null ? null : firstApproval,
        "jam_mulai": jamMulai == null ? null : jamMulai,
        "jam_selesai": jamSelesai == null ? null : jamSelesai,
      };
}

class ListApproval {
  ListApproval({
    this.statusApproval,
    this.tanggalApproval,
    this.warnaStatus,
    this.warnaFont,
  });

  String? statusApproval;
  DateTime? tanggalApproval;
  String? warnaStatus;
  String? warnaFont;

  factory ListApproval.fromJson(Map<String, dynamic> json) => ListApproval(
        statusApproval:
            json["status_approval"] == null ? null : json["status_approval"],
        tanggalApproval: json["tanggal_approval"] == null
            ? null
            : DateTime.parse(json["tanggal_approval"]),
        warnaStatus: json["warna_status"] == null ? null : json["warna_status"],
        warnaFont: json["warna_font"] == null ? null : json["warna_font"],
      );

  Map<String, dynamic> toJson() => {
        "status_approval": statusApproval == null ? null : statusApproval,
        "tanggal_approval":
            tanggalApproval == null ? null : tanggalApproval!.toIso8601String(),
        "warna_status": warnaStatus == null ? null : warnaStatus,
        "warna_font": warnaFont == null ? null : warnaFont,
      };
}

LemburHariIniRespon lemburHariIniResponFromJson(String str) =>
    LemburHariIniRespon.fromJson(json.decode(str));

String lemburHariIniResponToJson(LemburHariIniRespon data) =>
    json.encode(data.toJson());

class LemburHariIniRespon {
  LemburHariIniRespon({
    this.dataLokasi,
    this.statusButtonAbsensi,
    this.dataHariIni,
  });

  Lokasi? dataLokasi;
  StatusButtonAbsensi? statusButtonAbsensi;
  DataHariIni? dataHariIni;

  factory LemburHariIniRespon.fromJson(Map<String, dynamic> json) =>
      LemburHariIniRespon(
        dataLokasi: json["data_lokasi"] == null
            ? null
            : Lokasi.fromJson(json["data_lokasi"]),
        statusButtonAbsensi: json["status_button_absensi"] == null
            ? null
            : StatusButtonAbsensi.fromJson(json["status_button_absensi"]),
        dataHariIni: json["data_hari_ini"] == null
            ? null
            : DataHariIni.fromJson(json["data_hari_ini"]),
      );

  Map<String, dynamic> toJson() => {
        "data_lokasi": dataLokasi == null ? null : dataLokasi!.toJson(),
        "status_button_absensi":
            statusButtonAbsensi == null ? null : statusButtonAbsensi!.toJson(),
        "data_hari_ini": dataHariIni == null ? null : dataHariIni!.toJson(),
      };
}

class DataHariIni {
  DataHariIni({
    this.jamLemburMulai,
    this.jamLemburSelesai,
    this.tglLemburMulai,
    this.tglLemburSelesai,
  });

  String? jamLemburMulai;
  String? jamLemburSelesai;
  String? tglLemburMulai;
  String? tglLemburSelesai;

  factory DataHariIni.fromJson(Map<String, dynamic> json) => DataHariIni(
        jamLemburMulai:
            json["jam_lembur_mulai"] == null ? null : json["jam_lembur_mulai"],
        jamLemburSelesai: json["jam_lembur_selesai"] == null
            ? null
            : json["jam_lembur_selesai"],
        tglLemburMulai:
            json["tgl_lembur_mulai"] == null ? null : json["tgl_lembur_mulai"],
        tglLemburSelesai: json["tgl_lembur_selesai"] == null
            ? null
            : json["tgl_lembur_selesai"],
      );

  Map<String, dynamic> toJson() => {
        "jam_lembur_mulai": jamLemburMulai == null ? null : jamLemburMulai,
        "jam_lembur_selesai":
            jamLemburSelesai == null ? null : jamLemburSelesai,
        "tgl_lembur_mulai": tglLemburMulai == null ? null : tglLemburMulai,
        "tgl_lembur_selesai":
            tglLemburSelesai == null ? null : tglLemburSelesai,
      };
}

class StatusButtonAbsensi {
  StatusButtonAbsensi({
    this.enabledAbsenLembur,
    this.toggleAbsenLembur,
  });

  bool? enabledAbsenLembur;
  bool? toggleAbsenLembur;

  factory StatusButtonAbsensi.fromJson(Map<String, dynamic> json) =>
      StatusButtonAbsensi(
        enabledAbsenLembur: json["enabled_absen_lembur"] == null
            ? null
            : json["enabled_absen_lembur"],
        toggleAbsenLembur: json["toggle_absen_lembur"] == null
            ? null
            : json["toggle_absen_lembur"],
      );

  Map<String, dynamic> toJson() => {
        "enabled_absen_lembur":
            enabledAbsenLembur == null ? null : enabledAbsenLembur,
        "toggle_absen_lembur":
            toggleAbsenLembur == null ? null : toggleAbsenLembur,
      };
}

class DataAbsensi {
  String? idKaryawan;
  String? idCompany;
  String? jenisAbsen; // MASUK / PULANG / IST / DLL
  String? lokasiAbsen; // NAMA KANTORNYA
  String? latitude;
  String? longitude;
  String? tipeAbsen; // REG / LIBUR
  String? kodeAbsen; //H / I / C / DLL
  String? ketKodeAbsen; //Hadir / Izin / DLL
  String? jamKerja; // jam masuk - pulang
  String? keteranganAbsen;
  String? foto;
  String? tanggal;
  String? jam;
  String? jenisKamera;
  String? idAktivitas;
  String? fotoOld;

  DataAbsensi({
    this.idKaryawan,
    this.idCompany,
    this.jenisAbsen,
    this.lokasiAbsen,
    this.latitude,
    this.longitude,
    this.tipeAbsen,
    this.kodeAbsen,
    this.ketKodeAbsen,
    this.jamKerja,
    this.keteranganAbsen,
    this.foto,
    this.tanggal,
    this.jam,
    this.jenisKamera,
    this.idAktivitas,
    this.fotoOld,
  });
}
