// To parse this JSON data, do
//
//     final editAktivitas = editAktivitasFromJson(jsonString);

import 'dart:convert';

EditAktivitas editAktivitasFromJson(String str) =>
    EditAktivitas.fromJson(json.decode(str));

String editAktivitasToJson(EditAktivitas data) => json.encode(data.toJson());

class EditAktivitas {
  bool? success;
  String? message;
  List<Aktivitas>? data;

  EditAktivitas({
    this.success,
    this.message,
    this.data,
  });

  factory EditAktivitas.fromJson(Map<String, dynamic> json) => EditAktivitas(
        success: json["success"],
        message: json["message"],
        data: List<Aktivitas>.from(
            json["data"].map((x) => Aktivitas.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class Aktivitas {
  String? idAktivitas;
  String? idKaryawan;
  String? waktu;
  String? keterangan;
  String? lokasi;
  String? timezone;
  String? gmt;
  String? latitude;
  String? longitude;
  String? image;
  String? idCompany;
  String? tglInput;
  String? tglAktivitas;
  String? waktuAktivitas;

  Aktivitas({
    this.idAktivitas,
    this.idKaryawan,
    this.waktu,
    this.keterangan,
    this.lokasi,
    this.timezone,
    this.gmt,
    this.latitude,
    this.longitude,
    this.image,
    this.idCompany,
    this.tglInput,
    this.tglAktivitas,
    this.waktuAktivitas,
  });

  factory Aktivitas.fromJson(Map<String, dynamic> json) => Aktivitas(
        idAktivitas: json["id_aktivitas"],
        idKaryawan: json["id_karyawan"],
        waktu: json["waktu"],
        keterangan: json["keterangan"],
        lokasi: json["lokasi"],
        timezone: json["timezone"],
        gmt: json["gmt"],
        latitude: json["latitude"],
        longitude: json["longitude"],
        image: json["image"],
        idCompany: json["id_company"],
        tglInput: json["tgl_input"],
        tglAktivitas: json["tgl_aktivitas"],
        waktuAktivitas: json["waktu_aktivitas"],
      );

  Map<String, dynamic> toJson() => {
        "id_aktivitas": idAktivitas,
        "id_karyawan": idKaryawan,
        "waktu": waktu,
        "keterangan": keterangan,
        "lokasi": lokasi,
        "timezone": timezone,
        "gmt": gmt,
        "latitude": latitude,
        "longitude": longitude,
        "image": image,
        "id_company": idCompany,
        "tgl_input": tglInput,
        "tgl_aktivitas": tglAktivitas,
        "waktu_aktivitas": waktuAktivitas,
      };
}
