// To parse this JSON data, do
//
//     final masterKomponen = masterKomponenFromJson(jsonString);

import 'dart:convert';

MasterKomponen masterKomponenFromJson(String str) =>
    MasterKomponen.fromJson(json.decode(str));

String masterKomponenToJson(MasterKomponen data) => json.encode(data.toJson());

class MasterKomponen {
  MasterKomponen({
    this.success,
    this.data,
  });

  bool? success;
  List<DataKomponen>? data;

  factory MasterKomponen.fromJson(Map<String, dynamic> json) => MasterKomponen(
        success: json["success"],
        data: List<DataKomponen>.from(
            json["data"].map((x) => DataKomponen.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "data": List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataKomponen {
  DataKomponen({
    this.kodeKomponen,
    this.namaKomponen,
    this.flag,
  });

  String? kodeKomponen;
  String? namaKomponen;
  String? flag;

  factory DataKomponen.fromJson(Map<String, dynamic> json) => DataKomponen(
        kodeKomponen: json["kode_komponen"],
        namaKomponen: json["nama_komponen"],
        flag: json["flag"],
      );

  Map<String, dynamic> toJson() => {
        "kode_komponen": kodeKomponen,
        "nama_komponen": namaKomponen,
        "flag": flag,
      };
}

Logo logoFromJson(String str) => Logo.fromJson(json.decode(str));

String logoToJson(Logo data) => json.encode(data.toJson());

class Logo {
  Logo({
    this.success,
    this.data,
  });

  bool? success;
  DataLogo? data;

  factory Logo.fromJson(Map<String, dynamic> json) => Logo(
        success: json["success"],
        data: DataLogo.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "data": data!.toJson(),
      };
}

class DataLogo {
  DataLogo({
    this.logo,
  });

  String? logo;

  factory DataLogo.fromJson(Map<String, dynamic> json) => DataLogo(
        logo: json["logo"],
      );

  Map<String, dynamic> toJson() => {
        "logo": logo,
      };
}

RekapAbsensiDashboard rekapAbsensiDashboardFromJson(String str) =>
    RekapAbsensiDashboard.fromJson(json.decode(str));

String rekapAbsensiDashboardToJson(RekapAbsensiDashboard data) =>
    json.encode(data.toJson());

class RekapAbsensiDashboard {
  RekapAbsensiDashboard({
    this.success,
    this.data,
  });

  bool? success;
  DataRekapAbsensiDashboard? data;

  factory RekapAbsensiDashboard.fromJson(Map<String, dynamic> json) =>
      RekapAbsensiDashboard(
        success: json["success"],
        data: DataRekapAbsensiDashboard.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "data": data!.toJson(),
      };
}

class DataRekapAbsensiDashboard {
  DataRekapAbsensiDashboard({
    this.jmlHadir,
    this.jmlIzin,
    this.jmlCuti,
    this.sisaCuti,
  });

  int? jmlHadir;
  int? jmlIzin;
  int? jmlCuti;
  String? sisaCuti;

  factory DataRekapAbsensiDashboard.fromJson(Map<String, dynamic> json) =>
      DataRekapAbsensiDashboard(
        jmlHadir: json["jml_hadir"],
        jmlIzin: json["jml_izin"],
        jmlCuti: json["jml_cuti"],
        sisaCuti: json["sisa_cuti"],
      );

  Map<String, dynamic> toJson() => {
        "jml_hadir": jmlHadir,
        "jml_izin": jmlIzin,
        "jml_cuti": jmlCuti,
        "sisa_cuti": sisaCuti,
      };
}
