// To parse this JSON data, do
//
//     final beritaRespon = beritaResponFromJson(jsonString);

import 'dart:convert';

BeritaRespon beritaResponFromJson(String str) => BeritaRespon.fromJson(json.decode(str));

String beritaResponToJson(BeritaRespon data) => json.encode(data.toJson());

class BeritaRespon {
  BeritaRespon({
    this.success,
    this.message,
    this.data,
  });

  bool? success;
  String? message;
  List<DataBerita>? data;

  factory BeritaRespon.fromJson(Map<String, dynamic> json) => BeritaRespon(
    success: json["success"] == null ? null : json["success"],
    message: json["message"] == null ? null : json["message"],
    data: json["data"] == null ? null : List<DataBerita>.from(json["data"].map((x) => DataBerita.fromJson(x))),
  );

  Map<String, dynamic> toJson() => {
    "success": success == null ? null : success,
    "message": message == null ? null : message,
    "data": data == null ? null : List<dynamic>.from(data!.map((x) => x.toJson())),
  };
}

class DataBerita {
  DataBerita({
    this.idBerita,
    this.judul,
    this.content,
    this.creator,
    this.dateCreated,
    this.gambar,
    this.posting,
    this.tglPosting,
    this.idCompany,
    this.tglInput,
    this.namaPembuat,
    this.tanggalCreated,
    this.waktuCreated,
  });

  String? idBerita;
  String? judul;
  String? content;
  String? creator;
  DateTime? dateCreated;
  String? gambar;
  String? posting;
  DateTime? tglPosting;
  int? idCompany;
  DateTime? tglInput;
  String? namaPembuat;
  String? tanggalCreated;
  String? waktuCreated;

  factory DataBerita.fromJson(Map<String, dynamic> json) => DataBerita(
    idBerita: json["id_berita"] == null ? null : json["id_berita"],
    judul: json["judul"] == null ? null : json["judul"],
    content: json["content"] == null ? null : json["content"],
    creator: json["creator"] == null ? null : json["creator"],
    dateCreated: json["date_created"] == null ? null : DateTime.parse(json["date_created"]),
    gambar: json["gambar"] == null ? null : json["gambar"],
    posting: json["posting"] == null ? null : json["posting"],
    tglPosting: json["tgl_posting"] == null ? null : DateTime.parse(json["tgl_posting"]),
    idCompany: json["id_company"] == null ? null : json["id_company"],
    tglInput: json["tgl_input"] == null ? null : DateTime.parse(json["tgl_input"]),
    namaPembuat: json["nama_pembuat"] == null ? null : json["nama_pembuat"],
    tanggalCreated: json["tanggal_created"] == null ? null : json["tanggal_created"],
    waktuCreated: json["waktu_created"] == null ? null : json["waktu_created"],
  );

  Map<String, dynamic> toJson() => {
    "id_berita": idBerita == null ? null : idBerita,
    "judul": judul == null ? null : judul,
    "content": content == null ? null : content,
    "creator": creator == null ? null : creator,
    "date_created": dateCreated == null ? null : dateCreated!.toIso8601String(),
    "gambar": gambar == null ? null : gambar,
    "posting": posting == null ? null : posting,
    "tgl_posting": tglPosting == null ? null : tglPosting!.toIso8601String(),
    "id_company": idCompany == null ? null : idCompany,
    "tgl_input": tglInput == null ? null : tglInput!.toIso8601String(),
    "nama_pembuat": namaPembuat == null ? null : namaPembuat,
    "tanggal_created": tanggalCreated == null ? null : tanggalCreated,
    "waktu_created": waktuCreated == null ? null : waktuCreated,
  };
}
