import 'dart:convert';

MasterTahapanRespon masterTahapanResponFromJson(String str) => MasterTahapanRespon.fromJson(json.decode(str));

String masterTahapanResponToJson(MasterTahapanRespon data) => json.encode(data.toJson());

class MasterTahapanRespon {
  bool? success;
  String? message;
  List<DataTahapan>? data;

  MasterTahapanRespon({this.success, this.message, this.data});

  MasterTahapanRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data'] != null) {
      data = <DataTahapan>[];
      json['data'].forEach((v) {
        data!.add(new DataTahapan.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataTahapan {
  String? id;
  String? jenis;
  String? value;
  String? nama;
  String? warna;
  String? warnaText;
  int? jumlah;

  DataTahapan({this.id, this.jenis, this.value, this.nama, this.warna, this.jumlah});

  DataTahapan.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    jenis = json['jenis'];
    value = json['value'];
    nama = json['nama'];
    warna = json['warna'];
    warnaText = json['warna_text'];
    jumlah = json['jumlah'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['jenis'] = this.jenis;
    data['value'] = this.value;
    data['nama'] = this.nama;
    data['warna'] = this.warna;
    data['warna_text'] = this.warnaText;
    data['jumlah'] = this.jumlah;
    return data;
  }
}

