import 'dart:convert';

DetailKanbanBoardRespon detailKanbanBoardResponFromJson(String str) => DetailKanbanBoardRespon.fromJson(json.decode(str));

String detailsKanbanBoardToJson(DetailKanbanBoardRespon data) => json.encode(data.toJson());

class DetailKanbanBoardRespon {
  bool? success;
  String? message;
  DetailDataKanban? detailDataKanban;

  DetailKanbanBoardRespon({this.success, this.message, this.detailDataKanban});

  DetailKanbanBoardRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    detailDataKanban = json['detail_data_kanban'] != null
        ? new DetailDataKanban.fromJson(json['detail_data_kanban'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.detailDataKanban != null) {
      data['detail_data_kanban'] = this.detailDataKanban!.toJson();
    }
    return data;
  }
}

class DetailDataKanban {
  PipelineMain? pipelineMain;
  PipelineLog? pipelineLog;
  Button? button;

  DetailDataKanban({this.pipelineMain, this.pipelineLog, this.button});

  DetailDataKanban.fromJson(Map<String, dynamic> json) {
    pipelineMain = json['pipeline_main'] != null
        ? new PipelineMain.fromJson(json['pipeline_main'])
        : null;
    pipelineLog = json['pipeline_log'] != null
        ? new PipelineLog.fromJson(json['pipeline_log'])
        : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.pipelineMain != null) {
      data['pipeline_main'] = this.pipelineMain!.toJson();
    }
    if (this.pipelineLog != null) {
      data['pipeline_log'] = this.pipelineLog!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    return data;
  }
}

class PipelineMain {
  String? idPipelineMain;
  String? idTahapanM;
  String? idKaryawan;
  String? namaLengkap;
  String? title;
  String? keterangan;
  String? tahun;
  String? bulan;
  String? idPelanggan;
  String? namaPerusahaan;
  String? picNama;
  String? picTelp;
  String? tglInput;
  String? tglPengajuan;

  PipelineMain(
      {this.idPipelineMain,
        this.idTahapanM,
        this.idKaryawan,
        this.namaLengkap,
        this.title,
        this.keterangan,
        this.tahun,
        this.bulan,
        this.idPelanggan,
        this.namaPerusahaan,
        this.picNama,
        this.picTelp,
        this.tglInput,
        this.tglPengajuan});

  PipelineMain.fromJson(Map<String, dynamic> json) {
    idPipelineMain = json['id_pipeline_main'];
    idTahapanM = json['id_tahapan_m'];
    idKaryawan = json['id_karyawan'];
    namaLengkap = json['nama_lengkap'];
    title = json['title'];
    keterangan = json['keterangan'];
    tahun = json['tahun'];
    bulan = json['bulan'];
    idPelanggan = json['id_pelanggan'];
    namaPerusahaan = json['nama_perusahaan'];
    picNama = json['pic_nama'];
    picTelp = json['pic_telp'];
    tglInput = json['tgl_input'];
    tglPengajuan = json['tgl_pengajuan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_pipeline_main'] = this.idPipelineMain;
    data['id_tahapan_m'] = this.idTahapanM;
    data['id_karyawan'] = this.idKaryawan;
    data['nama_lengkap'] = this.namaLengkap;
    data['title'] = this.title;
    data['keterangan'] = this.keterangan;
    data['tahun'] = this.tahun;
    data['bulan'] = this.bulan;
    data['id_pelanggan'] = this.idPelanggan;
    data['nama_perusahaan'] = this.namaPerusahaan;
    data['pic_nama'] = this.picNama;
    data['pic_telp'] = this.picTelp;
    data['tgl_input'] = this.tglInput;
    data['tgl_pengajuan'] = this.tglPengajuan;
    return data;
  }
}

class PipelineLog {
  String? idPipelineMainLog;
  Tahapan? tahapanSebelum;
  Tahapan? tahapanSesudah;
  String? status;
  String? kategori;
  String? keterangan;

  PipelineLog(
      {this.idPipelineMainLog,
        this.tahapanSebelum,
        this.tahapanSesudah,
        this.status,
        this.kategori,
        this.keterangan});

  PipelineLog.fromJson(Map<String, dynamic> json) {
    idPipelineMainLog = json['id_pipeline_main_log'];
    tahapanSebelum = json['tahapan_sebelum'] != null
        ? new Tahapan.fromJson(json['tahapan_sebelum'])
        : null;
    tahapanSesudah = json['tahapan_sesudah'] != null
        ? new Tahapan.fromJson(json['tahapan_sesudah'])
        : null;
    status = json['status'];
    kategori = json['kategori'];
    keterangan = json['keterangan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_pipeline_main_log'] = this.idPipelineMainLog;
    if (this.tahapanSebelum != null) {
      data['tahapan_sebelum'] = this.tahapanSebelum!.toJson();
    }
    if (this.tahapanSesudah != null) {
      data['tahapan_sesudah'] = this.tahapanSesudah!.toJson();
    }
    data['status'] = this.status;
    data['kategori'] = this.kategori;
    data['keterangan'] = this.keterangan;
    return data;
  }
}

class Tahapan {
  String? idTahapanM;
  String? jenis;
  String? nama;
  String? warna;
  String? warnaText;
  int? noUrut;
  String? idCompany;

  Tahapan(
      {this.idTahapanM,
        this.jenis,
        this.nama,
        this.warna,
        this.warnaText,
        this.noUrut,
        this.idCompany});

  Tahapan.fromJson(Map<String, dynamic> json) {
    idTahapanM = json['id_tahapan_m'];
    jenis = json['jenis'];
    nama = json['nama'];
    warna = json['warna'];
    warnaText = json['warna_text'];
    noUrut = json['no_urut'];
    idCompany = json['id_company'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_tahapan_m'] = this.idTahapanM;
    data['jenis'] = this.jenis;
    data['nama'] = this.nama;
    data['warna'] = this.warna;
    data['warna_text'] = this.warnaText;
    data['no_urut'] = this.noUrut;
    data['id_company'] = this.idCompany;
    return data;
  }
}

class Button {
  bool? buttonApprove;
  bool? buttonTolak;

  Button({this.buttonApprove, this.buttonTolak});

  Button.fromJson(Map<String, dynamic> json) {
    buttonApprove = json['button_approve'];
    buttonTolak = json['button_tolak'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['button_approve'] = this.buttonApprove;
    data['button_tolak'] = this.buttonTolak;
    return data;
  }
}


