import 'dart:convert';

DailyAktivitasSalesRespon dailyAktivitasSalesResponFromJson(String str) => DailyAktivitasSalesRespon.fromJson(json.decode(str));

String dailyAktivitasSalesResponToJson(DailyAktivitasSalesRespon data) => json.encode(data.toJson());

class DailyAktivitasSalesRespon {
  bool? success;
  String? message;
  List<DataDailyAktivitasSales>? dataDailyAktivitasSales;

  DailyAktivitasSalesRespon({this.success, this.message, this.dataDailyAktivitasSales});

  DailyAktivitasSalesRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data_daily_aktivitas_sales'] != null) {
      dataDailyAktivitasSales = <DataDailyAktivitasSales>[];
      json['data_daily_aktivitas_sales'].forEach((v) {
        dataDailyAktivitasSales!.add(new DataDailyAktivitasSales.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataDailyAktivitasSales != null) {
      data['data_daily_aktivitas_sales'] =
          this.dataDailyAktivitasSales!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataDailyAktivitasSales {
  String? tabel;
  String? id;
  String? idKaryawan;
  Status? status;
  String? idPipelineMain;
  String? idPipelineMainLog;
  String? idPelanggan;
  String? tahapanSebelum;
  String? tahapanSekarang;
  String? kategori;
  String? aktivitas;
  String? keterangan;
  String? ketMove;
  String? point;
  String? waktu;
  String? userInput;
  String? userId;
  Button? button;
  String? jam;
  bool? showStatus;
  String? namaPelanggan;
  String? flagLokasi;
  String? flagUploadFoto;
  String? latitude;
  String? longitude;
  String? pathFoto;
  String? tanggal;

  DataDailyAktivitasSales(
      {this.tabel,
        this.id,
        this.idKaryawan,
        this.status,
        this.idPipelineMain,
        this.idPipelineMainLog,
        this.idPelanggan,
        this.tahapanSebelum,
        this.tahapanSekarang,
        this.kategori,
        this.aktivitas,
        this.keterangan,
        this.ketMove,
        this.point,
        this.waktu,
        this.userInput,
        this.userId,
        this.button,
        this.jam,
        this.showStatus,
        this.namaPelanggan,
        this.flagLokasi,
        this.flagUploadFoto,
        this.latitude,
        this.longitude,
        this.pathFoto,
        this.tanggal});

  DataDailyAktivitasSales.fromJson(Map<String, dynamic> json) {
    tabel = json['tabel'];
    id = json['id'];
    idKaryawan = json['id_karyawan'];
    status = json['status'] != null ? new Status.fromJson(json['status']) : null;
    idPipelineMain = json['id_pipeline_main'];
    idPipelineMainLog = json['id_pipeline_main_log'];
    idPelanggan = json['id_pelanggan'];
    tahapanSebelum = json['tahapan_sebelum'];
    tahapanSekarang = json['tahapan_sekarang'];
    kategori = json['kategori'];
    aktivitas = json['aktivitas'];
    keterangan = json['keterangan'];
    ketMove = json['ket_move'];
    point = json['point'];
    waktu = json['waktu'];
    userInput = json['user_input'];
    userId = json['user_id'];
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
    jam = json['jam'];
    showStatus = json['show_status'];
    namaPelanggan = json['nama_perusahaan'];
    flagLokasi = json['flag_lokasi'];
    flagUploadFoto = json['flag_upload_foto'];
    latitude = json['latitude'];
    longitude = json['longitude'];
    pathFoto = json['path_foto'];
    tanggal = json['tanggal'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tabel'] = this.tabel;
    data['id'] = this.id;
    data['id_karyawan'] = this.idKaryawan;
    if (this.status != null) {
      data['status'] = this.status!.toJson();
    }
    data['id_pipeline_main'] = this.idPipelineMain;
    data['id_pipeline_main_log'] = this.idPipelineMainLog;
    data['id_pelanggan'] = this.idPelanggan;
    data['tahapan_sebelum'] = this.tahapanSebelum;
    data['tahapan_sekarang'] = this.tahapanSekarang;
    data['kategori'] = this.kategori;
    data['aktivitas'] = this.aktivitas;
    data['keterangan'] = this.keterangan;
    data['ket_move'] = this.ketMove;
    data['point'] = this.point;
    data['waktu'] = this.waktu;
    data['user_input'] = this.userInput;
    data['user_id'] = this.userId;
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    data['jam'] = this.jam;
    data['show_status'] = this.showStatus;
    data['nama_perusahaan'] = this.namaPelanggan;
    data['flag_lokasi'] = this.flagLokasi;
    data['flag_upload_foto'] = this.flagUploadFoto;
    data['latitude'] = this.latitude;
    data['longitude'] = this.longitude;
    data['path_foto'] = this.pathFoto;
    data['tanggal'] = this.tanggal;
    return data;
  }
}

class Status {
  String? status;
  String? color;
  String? fontColor;

  Status({this.status, this.color, this.fontColor});

  Status.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    color = json['color'];
    fontColor = json['font_color'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['status'] = this.status;
    data['color'] = this.color;
    data['font_color'] = this.fontColor;
    return data;
  }
}

class Button {
  bool? buttonDetail;
  bool? buttonApprove;

  Button({this.buttonDetail, this.buttonApprove});

  Button.fromJson(Map<String, dynamic> json) {
    buttonDetail = json['button_detail'];
    buttonApprove = json['button_approve'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['button_detail'] = this.buttonDetail;
    data['button_approve'] = this.buttonApprove;
    return data;
  }
}
