import 'dart:convert';

PageLoginModel pageLoginModelFromJson(String str) => PageLoginModel.fromJson(json.decode(str));

String pageLoginModelToJson(PageLoginModel data) => json.encode(data.toJson());

class PageLoginModel {
  MenuLogin? menuLogin;
  MenuUsernameLupaPassword? menuUsernameLupaPassword;
  MenuEmailLupaPassword? menuEmailLupaPassword;
  MenuLupaPasswordSuccess? menuLupaPasswordSuccess;
  Message? message;
  String? locale;

  PageLoginModel(
      {this.menuLogin,
        this.menuUsernameLupaPassword,
        this.menuEmailLupaPassword,
        this.menuLupaPasswordSuccess,
        this.message,
        this.locale});

  PageLoginModel.fromJson(Map<String, dynamic> json) {
    menuLogin = json['menu_login'] != null
        ? new MenuLogin.fromJson(json['menu_login'])
        : null;
    menuUsernameLupaPassword = json['menu_username_lupa_password'] != null
        ? new MenuUsernameLupaPassword.fromJson(
        json['menu_username_lupa_password'])
        : null;
    menuEmailLupaPassword = json['menu_email_lupa_password'] != null
        ? new MenuEmailLupaPassword.fromJson(json['menu_email_lupa_password'])
        : null;
    menuLupaPasswordSuccess = json['menu_lupa_password_success'] != null
        ? new MenuLupaPasswordSuccess.fromJson(
        json['menu_lupa_password_success'])
        : null;
    message =
    json['message'] != null ? new Message.fromJson(json['message']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuLogin != null) {
      data['menu_login'] = this.menuLogin!.toJson();
    }
    if (this.menuUsernameLupaPassword != null) {
      data['menu_username_lupa_password'] =
          this.menuUsernameLupaPassword!.toJson();
    }
    if (this.menuEmailLupaPassword != null) {
      data['menu_email_lupa_password'] = this.menuEmailLupaPassword!.toJson();
    }
    if (this.menuLupaPasswordSuccess != null) {
      data['menu_lupa_password_success'] =
          this.menuLupaPasswordSuccess!.toJson();
    }
    if (this.message != null) {
      data['message'] = this.message!.toJson();
    }
    return data;
  }
}

class MenuLogin {
  String? username;
  String? password;
  String? lupaPassword;
  String? btnMasuk;

  MenuLogin({this.username, this.password, this.lupaPassword, this.btnMasuk});

  MenuLogin.fromJson(Map<String, dynamic> json) {
    username = json['username'];
    password = json['password'];
    lupaPassword = json['lupa_password'];
    btnMasuk = json['btn_masuk'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['username'] = this.username;
    data['password'] = this.password;
    data['lupa_password'] = this.lupaPassword;
    data['btn_masuk'] = this.btnMasuk;
    return data;
  }
}

class MenuUsernameLupaPassword {
  String? title;
  String? header;
  String? subHeader;
  String? username;
  String? labelIngatPassword;
  String? btnNext;

  MenuUsernameLupaPassword(
      {this.title,
        this.header,
        this.subHeader,
        this.username,
        this.labelIngatPassword,
        this.btnNext});

  MenuUsernameLupaPassword.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    header = json['header'];
    subHeader = json['sub_header'];
    username = json['username'];
    labelIngatPassword = json['label_ingat_password'];
    btnNext = json['btn_next'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['header'] = this.header;
    data['sub_header'] = this.subHeader;
    data['username'] = this.username;
    data['label_ingat_password'] = this.labelIngatPassword;
    data['btn_next'] = this.btnNext;
    return data;
  }
}

class MenuEmailLupaPassword {
  String? title;
  String? header;
  String? subHeader;
  String? email;
  String? labelIngatPassword;
  String? btnNext;

  MenuEmailLupaPassword(
      {this.title,
        this.header,
        this.subHeader,
        this.email,
        this.labelIngatPassword,
        this.btnNext});

  MenuEmailLupaPassword.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    header = json['header'];
    subHeader = json['sub_header'];
    email = json['email'];
    labelIngatPassword = json['label_ingat_password'];
    btnNext = json['btn_next'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['header'] = this.header;
    data['sub_header'] = this.subHeader;
    data['email'] = this.email;
    data['label_ingat_password'] = this.labelIngatPassword;
    data['btn_next'] = this.btnNext;
    return data;
  }
}

class MenuLupaPasswordSuccess {
  String? title;
  String? header;
  String? subHeader;
  String? btnLogin;

  MenuLupaPasswordSuccess(
      {this.title, this.header, this.subHeader, this.btnLogin});

  MenuLupaPasswordSuccess.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    header = json['header'];
    subHeader = json['sub_header'];
    btnLogin = json['btn_login'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['header'] = this.header;
    data['sub_header'] = this.subHeader;
    data['btn_login'] = this.btnLogin;
    return data;
  }
}

class Message {
  String? peringatan;
  String? exit;
  String? btnYa;
  String? btnTidak;
  String? usernameEmpty;
  String? tidakDitemukan;
  String? usernameTidakDitemukan;
  String? emailEmpty;
  String? emailTidakDitemukan;

  Message(
      {this.peringatan,
        this.exit,
        this.btnYa,
        this.btnTidak,
        this.usernameEmpty,
        this.tidakDitemukan,
        this.usernameTidakDitemukan,
        this.emailEmpty,
        this.emailTidakDitemukan});

  Message.fromJson(Map<String, dynamic> json) {
    peringatan = json['peringatan'];
    exit = json['exit'];
    btnYa = json['btn_ya'];
    btnTidak = json['btn_tidak'];
    usernameEmpty = json['username_empty'];
    tidakDitemukan = json['tidak_ditemukan'];
    usernameTidakDitemukan = json['username_tidak_ditemukan'];
    emailEmpty = json['email_empty'];
    emailTidakDitemukan = json['email_tidak_ditemukan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['peringatan'] = this.peringatan;
    data['exit'] = this.exit;
    data['btn_ya'] = this.btnYa;
    data['btn_tidak'] = this.btnTidak;
    data['username_empty'] = this.usernameEmpty;
    data['tidak_ditemukan'] = this.tidakDitemukan;
    data['username_tidak_ditemukan'] = this.usernameTidakDitemukan;
    data['email_empty'] = this.emailEmpty;
    data['email_tidak_ditemukan'] = this.emailTidakDitemukan;
    return data;
  }
}
