import 'dart:convert';

PageLemburModel pageLemburModelFromJson(String str) =>
    PageLemburModel.fromJson(json.decode(str));

String pageLemburModelToJson(PageLemburModel data) =>
    json.encode(data.toJson());

class PageLemburModel {
  MenuLembur? menuLembur;

  PageLemburModel({this.menuLembur});

  PageLemburModel.fromJson(Map<String, dynamic> json) {
    menuLembur = json['menu_lembur'] != null
        ? new MenuLembur.fromJson(json['menu_lembur'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuLembur != null) {
      data['menu_lembur'] = this.menuLembur!.toJson();
    }
    return data;
  }
}

class MenuLembur {
  String? title;
  String? titleDetail;
  String? titleRekap;
  String? tabSaya;
  String? tabKaryawan;
  String? bahasa;
  Data? data;
  Button? button;
  MessageKonfirmasi? messageKonfirmasi;
  String? locale;

  MenuLembur(
      {this.title,
      this.titleDetail,
      this.titleRekap,
      this.tabSaya,
      this.tabKaryawan,
      this.bahasa,
      this.data,
      this.button,
      this.messageKonfirmasi,
      this.locale});

  MenuLembur.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    titleDetail = json['title_detail'];
    titleRekap = json['title_rekap'];
    tabSaya = json['tab_saya'];
    tabKaryawan = json['tab_karyawan'];
    bahasa = json['bahasa'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    button =
        json['button'] != null ? new Button.fromJson(json['button']) : null;
    messageKonfirmasi = json['message_konfirmasi'] != null
        ? new MessageKonfirmasi.fromJson(json['message_konfirmasi'])
        : null;
    locale = json['locale'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['title_detail'] = this.titleDetail;
    data['title_rekap'] = this.titleRekap;
    data['tab_saya'] = this.tabSaya;
    data['tab_karyawan'] = this.tabKaryawan;
    data['bahasa'] = this.bahasa;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    if (this.messageKonfirmasi != null) {
      data['message_konfirmasi'] = this.messageKonfirmasi!.toJson();
    }
    data['locale'] = this.locale;
    return data;
  }
}

class Data {
  String? header;
  String? tanggalPengajuan;
  String? dataKaryawan;
  String? namaKaryawan;
  String? jabatan;
  String? cabang;
  String? departemen;
  String? totalLembur;
  String? approval;
  String? jamMulai;
  String? jamSelesai;
  String? lemburMulai;
  String? lemburSelesai;
  String? keterangan;
  String? lokasi;
  String? lokasiAbsen;
  String? akurasi;
  String? registrasi;
  String? titlePeringatan;
  String? info;
  String? approvalLembur;
  String? jam;
  String? menit;
  Data(
      {this.header,
      this.tanggalPengajuan,
      this.dataKaryawan,
      this.namaKaryawan,
      this.jabatan,
      this.cabang,
      this.departemen,
      this.totalLembur,
      this.approval,
      this.jamMulai,
      this.jamSelesai,
      this.lemburMulai,
      this.lemburSelesai,
      this.keterangan,
      this.lokasi,
      this.lokasiAbsen,
      this.akurasi,
      this.registrasi,
      this.titlePeringatan,
      this.info,
      this.approvalLembur,
      this.jam,
      this.menit});

  Data.fromJson(Map<String, dynamic> json) {
    header = json['header'];
    tanggalPengajuan = json['tanggal_pengajuan'];
    dataKaryawan = json['data_karyawan'];
    namaKaryawan = json['nama_karyawan'];
    jabatan = json['jabatan'];
    cabang = json['cabang'];
    departemen = json['departemen'];
    totalLembur = json['total_lembur'];
    approval = json['approval'];
    jamMulai = json['jam_mulai'];
    jamSelesai = json['jam_selesai'];
    lemburMulai = json['lembur_mulai'];
    lemburSelesai = json['lembur_selesai'];
    keterangan = json['keterangan'];
    lokasi = json['lokasi'];
    lokasiAbsen = json['lokasi_absen'];
    akurasi = json['akurasi'];
    registrasi = json['registrasi'];
    titlePeringatan = json['title_peringatan'];
    info = json['info'];
    approvalLembur = json['approval_lembur'];
    jam = json['jam'];
    menit = json['menit'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    data['tanggal_pengajuan'] = this.tanggalPengajuan;
    data['data_karyawan'] = this.dataKaryawan;
    data['nama_karyawan'] = this.namaKaryawan;
    data['jabatan'] = this.jabatan;
    data['cabang'] = this.cabang;
    data['departemen'] = this.departemen;
    data['total_lembur'] = this.totalLembur;
    data['approval'] = this.approval;
    data['jam_mulai'] = this.jamMulai;
    data['jam_selesai'] = this.jamSelesai;
    data['lembur_mulai'] = this.lemburMulai;
    data['lembur_selesai'] = this.lemburSelesai;
    data['keterangan'] = this.keterangan;
    data['lokasi'] = this.lokasi;
    data['lokasi_absen'] = this.lokasiAbsen;
    data['akurasi'] = this.akurasi;
    data['registrasi'] = this.registrasi;
    data['title_peringatan'] = this.titlePeringatan;
    data['info'] = this.info;
    data['approval_lembur'] = this.approvalLembur;
    data['menit'] = this.menit;
    data['jam'] = this.jam;
    return data;
  }
}

class Button {
  String? btnMulai;
  String? btnSelesai;
  String? btnCancel;
  String? btnClose;
  String? btnSubmit;
  String? btnTolak;
  String? btnTolakSemua;
  String? btnSetujui;
  String? btnSetujuiSemua;

  Button(
      {this.btnMulai,
      this.btnSelesai,
      this.btnCancel,
      this.btnClose,
      this.btnSubmit,
      this.btnTolak,
      this.btnTolakSemua,
      this.btnSetujui,
      this.btnSetujuiSemua});

  Button.fromJson(Map<String, dynamic> json) {
    btnMulai = json['btn_mulai'];
    btnSelesai = json['btn_selesai'];
    btnCancel = json['btn_cancel'];
    btnClose = json['btn_close'];
    btnSubmit = json['btn_submit'];
    btnTolak = json['btn_tolak'];
    btnTolakSemua = json['btn_tolak_semua'];
    btnSetujui = json['btn_setujui'];
    btnSetujuiSemua = json['btn_setujui_semua'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['btn_mulai'] = this.btnMulai;
    data['btn_selesai'] = this.btnSelesai;
    data['btn_cancel'] = this.btnCancel;
    data['btn_close'] = this.btnClose;
    data['btn_submit'] = this.btnSubmit;
    data['btn_tolak'] = this.btnTolak;
    data['btn_tolak_semua'] = this.btnTolakSemua;
    data['btn_setujui'] = this.btnSetujui;
    data['btn_setujui_semua'] = this.btnSetujuiSemua;
    return data;
  }
}

class MessageKonfirmasi {
  String? tolakSemua;
  String? tolak;
  String? setujuiSemua;
  String? setujui;
  String? kamera;
  String? waktu;

  MessageKonfirmasi(
      {this.tolakSemua, this.tolak, this.setujuiSemua, this.setujui});

  MessageKonfirmasi.fromJson(Map<String, dynamic> json) {
    tolakSemua = json['tolak_semua'];
    tolak = json['tolak'];
    setujuiSemua = json['setujui_semua'];
    setujui = json['setujui'];
    kamera = json['kamera'];
    waktu = json['waktu'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tolak_semua'] = this.tolakSemua;
    data['tolak'] = this.tolak;
    data['setujui_semua'] = this.setujuiSemua;
    data['setujui'] = this.setujui;
    data['kamera'] = this.kamera;
    data['waktu'] = this.waktu;
    return data;
  }
}
