import 'dart:convert';

PageIzinModel pageIzinModelFromJson(String str) => PageIzinModel.fromJson(json.decode(str));

String pageIzinModelToJson(PageIzinModel data) => json.encode(data.toJson());

class PageIzinModel {
  MenuIzin? menuIzin;

  PageIzinModel({this.menuIzin});

  PageIzinModel.fromJson(Map<String, dynamic> json) {
    menuIzin = json['menu_izin'] != null
        ? new MenuIzin.fromJson(json['menu_izin'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuIzin != null) {
      data['menu_izin'] = this.menuIzin!.toJson();
    }
    return data;
  }
}

class MenuIzin {
  Title? title;
  Data? data;
  Button? button;
  PesanKonfirmasi? pesanKonfirmasi;

  MenuIzin({this.title, this.data, this.button, this.pesanKonfirmasi});

  MenuIzin.fromJson(Map<String, dynamic> json) {
    title = json['title'] != null ? new Title.fromJson(json['title']) : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
    pesanKonfirmasi = json['pesan_konfirmasi'] != null
        ? new PesanKonfirmasi.fromJson(json['pesan_konfirmasi'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.title != null) {
      data['title'] = this.title!.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    if (this.pesanKonfirmasi != null) {
      data['pesan_konfirmasi'] = this.pesanKonfirmasi!.toJson();
    }
    return data;
  }
}

class Title {
  String? parentTitle;
  String? titleDetail;
  String? titleRekap;
  String? tabSaya;
  String? tabKaryawan;
  String? titleIzin;
  Title(
      {this.parentTitle,
        this.titleDetail,
        this.titleRekap,
        this.tabSaya,
        this.tabKaryawan,
        this.titleIzin
      });

  Title.fromJson(Map<String, dynamic> json) {
    parentTitle = json['parent_title'];
    titleDetail = json['title_detail'];
    titleRekap = json['title_rekap'];
    tabSaya = json['tab_saya'];
    tabKaryawan = json['tab_karyawan'];
    titleIzin = json['title_izin'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['parent_title'] = this.parentTitle;
    data['title_detail'] = this.titleDetail;
    data['title_rekap'] = this.titleRekap;
    data['tab_saya'] = this.tabSaya;
    data['tab_karyawan'] = this.tabKaryawan;
    data['title_izin'] = this.titleIzin;
    return data;
  }
}

class Data {
  String? dataKaryawan;
  String? jabatan;
  String? cabang;
  String? departemen;
  String? dataIzin;
  String? tanggalPengajuan;
  String? namaKaryawan;
  String? tanggalIzin;
  String? jumlahIzin;
  String? namaIzin;
  String? keteranganIzin;
  String? approval;
  String? lampiran;
  String? jenisIzin;
  String? infoMengurangiCuti;
  String? infoSisaCuti;
  String? infoSisaCutiKaryawan;
  String? infoCutiBerlakuHingga;
  String? keterangan;
  String? hari;
  String? ambilGambar;

  Data(
      {this.dataKaryawan,
        this.jabatan,
        this.cabang,
        this.departemen,
        this.dataIzin,
        this.tanggalPengajuan,
        this.namaKaryawan,
        this.tanggalIzin,
        this.jumlahIzin,
        this.namaIzin,
        this.keteranganIzin,
        this.approval,
        this.lampiran,
        this.jenisIzin,
        this.infoMengurangiCuti,
        this.infoSisaCuti,
        this.infoSisaCutiKaryawan,
        this.infoCutiBerlakuHingga,
        this.keterangan,
        this.hari,
        this.ambilGambar});

  Data.fromJson(Map<String, dynamic> json) {
    dataKaryawan = json['data_karyawan'];
    jabatan = json['jabatan'];
    cabang = json['cabang'];
    departemen = json['departemen'];
    dataIzin = json['data_izin'];
    tanggalPengajuan = json['tanggal_pengajuan'];
    namaKaryawan = json['nama_karyawan'];
    tanggalIzin = json['tanggal_izin'];
    jumlahIzin = json['jumlah_izin'];
    namaIzin = json['nama_izin'];
    keteranganIzin = json['keterangan_izin'];
    approval = json['approval'];
    lampiran = json['lampiran'];
    jenisIzin = json['jenis_izin'];
    infoMengurangiCuti = json['info_mengurangi_cuti'];
    infoSisaCuti = json['info_sisa_cuti'];
    infoSisaCutiKaryawan = json['info_sisa_cuti_karyawan'];
    infoCutiBerlakuHingga = json['info_cuti_berlaku_hingga'];
    keterangan = json['keterangan'];
    hari = json['hari'];
    ambilGambar = json['ambil_gambar'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['data_karyawan'] = this.dataKaryawan;
    data['jabatan'] = this.jabatan;
    data['cabang'] = this.cabang;
    data['departemen'] = this.departemen;
    data['data_izin'] = this.dataIzin;
    data['tanggal_pengajuan'] = this.tanggalPengajuan;
    data['nama_karyawan'] = this.namaKaryawan;
    data['tanggal_izin'] = this.tanggalIzin;
    data['jumlah_izin'] = this.jumlahIzin;
    data['nama_izin'] = this.namaIzin;
    data['keterangan_izin'] = this.keteranganIzin;
    data['approval'] = this.approval;
    data['lampiran'] = this.lampiran;
    data['jenis_izin'] = this.jenisIzin;
    data['info_mengurangi_cuti'] = this.infoMengurangiCuti;
    data['info_sisa_cuti'] = this.infoSisaCuti;
    data['info_sisa_cuti_karyawan'] = this.infoSisaCutiKaryawan;
    data['info_cuti_berlaku_hingga'] = this.infoCutiBerlakuHingga;
    data['keterangan'] = this.keterangan;
    data['hari'] = this.hari;
    data['ambil_gambar'] = this.ambilGambar;
    return data;
  }
}

class Button {
  String? detail;
  String? batalkan;
  String? setujui;
  String? tolak;
  String? setujuiSemua;
  String? tolakSemua;
  String? btnSubmit;

  Button(
      {this.detail,
        this.batalkan,
        this.setujui,
        this.tolak,
        this.setujuiSemua,
        this.tolakSemua,
        this.btnSubmit});

  Button.fromJson(Map<String, dynamic> json) {
    detail = json['detail'];
    batalkan = json['batalkan'];
    setujui = json['setujui'];
    tolak = json['tolak'];
    setujuiSemua = json['setujui_semua'];
    tolakSemua = json['tolak_semua'];
    btnSubmit = json['btn_submit'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['detail'] = this.detail;
    data['batalkan'] = this.batalkan;
    data['setujui'] = this.setujui;
    data['tolak'] = this.tolak;
    data['setujui_semua'] = this.setujuiSemua;
    data['tolak_semua'] = this.tolakSemua;
    data['btn_submit'] = this.btnSubmit;
    return data;
  }
}

class PesanKonfirmasi {
  String? tolak;
  String? tolakSemua;
  String? setujui;
  String? setujuiSemua;
  String? batalkan;
  String? jenisIsEmpty;
  String? tanggalIsEmpty;
  String? fileIsEmpty;
  String? ketIsEmpty;
  String? tidakAdaLampiran;

  PesanKonfirmasi(
      {this.tolak,
        this.tolakSemua,
        this.setujui,
        this.setujuiSemua,
        this.batalkan,
        this.jenisIsEmpty,
        this.tanggalIsEmpty,
        this.fileIsEmpty,
        this.ketIsEmpty,
        this.tidakAdaLampiran});

  PesanKonfirmasi.fromJson(Map<String, dynamic> json) {
    tolak = json['tolak'];
    tolakSemua = json['tolak_semua'];
    setujui = json['setujui'];
    setujuiSemua = json['setujui_semua'];
    batalkan = json['batalkan'];
    jenisIsEmpty = json['jenis_is_empty'];
    tanggalIsEmpty = json['tanggal_is_empty'];
    fileIsEmpty = json['file_is_empty'];
    ketIsEmpty = json['ket_is_empty'];
    tidakAdaLampiran = json['tidak_ada_lampiran'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tolak'] = this.tolak;
    data['tolak_semua'] = this.tolakSemua;
    data['setujui'] = this.setujui;
    data['setujui_semua'] = this.setujuiSemua;
    data['batalkan'] = this.batalkan;
    data['jenis_is_empty'] = this.jenisIsEmpty;
    data['tanggal_is_empty'] = this.tanggalIsEmpty;
    data['file_is_empty'] = this.fileIsEmpty;
    data['ket_is_empty'] = this.ketIsEmpty;
    data['tidak_ada_lampiran'] = this.tidakAdaLampiran;
    return data;
  }
}


