import 'dart:convert';

PageDetailAbsensiModel pageDetailAbsensiModelFromJson(String str) => PageDetailAbsensiModel.fromJson(json.decode(str));

String pageDetailAbsensiModelToJson(PageDetailAbsensiModel data) => json.encode(data.toJson());

class PageDetailAbsensiModel {
  MenuDetailAbsensi? menuDetailAbsensi;

  PageDetailAbsensiModel({this.menuDetailAbsensi});

  PageDetailAbsensiModel.fromJson(Map<String, dynamic> json) {
    menuDetailAbsensi = json['menu_detail_absensi'] != null
        ? new MenuDetailAbsensi.fromJson(json['menu_detail_absensi'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuDetailAbsensi != null) {
      data['menu_detail_absensi'] = this.menuDetailAbsensi!.toJson();
    }
    return data;
  }
}

class MenuDetailAbsensi {
  String? title;
  Data? data;

  MenuDetailAbsensi({this.title, this.data});

  MenuDetailAbsensi.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    return data;
  }
}

class Data {
  String? namaKaryawan;
  Absensi? absensi;
  Istirahat? istirahat;
  DataKaryawan? dataKaryawan;


  Data({this.namaKaryawan, this.absensi, this.istirahat});

  Data.fromJson(Map<String, dynamic> json) {
    namaKaryawan = json['nama_karyawan'];
    absensi =
    json['absensi'] != null ? new Absensi.fromJson(json['absensi']) : null;
    istirahat = json['istirahat'] != null
        ? new Istirahat.fromJson(json['istirahat'])
        : null;
    dataKaryawan = json['data_karyawan'] != null
        ? new DataKaryawan.fromJson(json['data_karyawan'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['nama_karyawan'] = this.namaKaryawan;
    if (this.absensi != null) {
      data['absensi'] = this.absensi!.toJson();
    }
    if (this.istirahat != null) {
      data['istirahat'] = this.istirahat!.toJson();
    }
    if (this.dataKaryawan != null) {
      data['data_karyawan'] = this.dataKaryawan!.toJson();
    }
    return data;
  }
}

class Absensi {
  String? header;
  String? masuk;
  String? pulang;
  String? keterangan;

  Absensi({this.header, this.masuk, this.pulang, this.keterangan});

  Absensi.fromJson(Map<String, dynamic> json) {
    header = json['header'];
    masuk = json['masuk'];
    pulang = json['pulang'];
    keterangan = json['keterangan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    data['masuk'] = this.masuk;
    data['pulang'] = this.pulang;
    data['keterangan'] = this.keterangan;
    return data;
  }
}

class Istirahat {
  String? header;
  String? mulaiIstirahat;
  String? selesaiIstirahat;
  String? keterangan;

  Istirahat(
      {this.header,
        this.mulaiIstirahat,
        this.selesaiIstirahat,
        this.keterangan});

  Istirahat.fromJson(Map<String, dynamic> json) {
    header = json['header'];
    mulaiIstirahat = json['mulai_istirahat'];
    selesaiIstirahat = json['selesai_istirahat'];
    keterangan = json['keterangan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    data['mulai_istirahat'] = this.mulaiIstirahat;
    data['selesai_istirahat'] = this.selesaiIstirahat;
    data['keterangan'] = this.keterangan;
    return data;
  }
}
class DataKaryawan {
  String? nama;
  String? nik;
  String? jabatan;
  String? cabang;
  String? departemen;

  DataKaryawan(
      {this.nama,
        this.nik,
        this.jabatan,
        this.cabang,
      this.departemen});

  DataKaryawan.fromJson(Map<String, dynamic> json) {
    nama = json['nama'];
    nik = json['nik'];
    jabatan = json['jabatan'];
    cabang=json['cabang'];
    departemen = json['departemen'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['nama'] = this.nama;
    data['nik'] = this.nik;
    data['jabatan'] = this.jabatan;
    data['cabang'] = this.cabang;
    data['departemen'] = this.departemen;
    return data;
  }
}
