import 'dart:convert';

PageDataPengalamanKerjaModel pageDataPengalamanKerjaModelFromJson(String str) => PageDataPengalamanKerjaModel.fromJson(json.decode(str));

String pageDataPengalamanKerjaModelToJson(PageDataPengalamanKerjaModel data) => json.encode(data.toJson());

class PageDataPengalamanKerjaModel {
  MenuDataPengalamanKerja? menuDataPengalamanKerja;

  PageDataPengalamanKerjaModel({this.menuDataPengalamanKerja});

  PageDataPengalamanKerjaModel.fromJson(Map<String, dynamic> json) {
    menuDataPengalamanKerja = json['menu_data_pengalaman_kerja'] != null
        ? new MenuDataPengalamanKerja.fromJson(
        json['menu_data_pengalaman_kerja'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuDataPengalamanKerja != null) {
      data['menu_data_pengalaman_kerja'] =
          this.menuDataPengalamanKerja!.toJson();
    }
    return data;
  }
}

class MenuDataPengalamanKerja {
  String? title;
  String? editTitle;
  String? addTitle;
  String? terverifikasi;
  String? pengajuan;
  DataPengalamanKerja? dataPengalamanKerja;
  Button? button;
  Message? message;
  String? locale;

  MenuDataPengalamanKerja(
      {this.title,
        this.editTitle,
        this.addTitle,
        this.terverifikasi,
        this.pengajuan,
        this.dataPengalamanKerja,
        this.button,
        this.message,
        this.locale});

  MenuDataPengalamanKerja.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    editTitle = json['edit_title'];
    addTitle = json['add_title'];
    terverifikasi = json['terverifikasi'];
    pengajuan = json['pengajuan'];
    dataPengalamanKerja = json['data_pengalaman_kerja'] != null
        ? new DataPengalamanKerja.fromJson(json['data_pengalaman_kerja'])
        : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
    message =
    json['message'] != null ? new Message.fromJson(json['message']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['edit_title'] = this.editTitle;
    data['add_title'] = this.addTitle;
    data['terverifikasi'] = this.terverifikasi;
    data['pengajuan'] = this.pengajuan;
    if (this.dataPengalamanKerja != null) {
      data['data_pengalaman_kerja'] = this.dataPengalamanKerja!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    if (this.message != null) {
      data['message'] = this.message!.toJson();
    }
    return data;
  }
}

class DataPengalamanKerja {
  String? namaPerusahaan;
  String? jenisPerusahaan;
  String? jabatanTerakhir;
  String? alamatPerusahaan;
  String? provinsi;
  String? kabupaten;
  String? tanggalMulaiKerja;
  String? tanggalBerhentiKerja;
  String? alasanBerhenti;
  String? lampiran;

  DataPengalamanKerja(
      {this.namaPerusahaan,
        this.jenisPerusahaan,
        this.jabatanTerakhir,
        this.alamatPerusahaan,
        this.provinsi,
        this.kabupaten,
        this.tanggalMulaiKerja,
        this.tanggalBerhentiKerja,
        this.alasanBerhenti,
        this.lampiran});

  DataPengalamanKerja.fromJson(Map<String, dynamic> json) {
    namaPerusahaan = json['nama_perusahaan'];
    jenisPerusahaan = json['jenis_perusahaan'];
    jabatanTerakhir = json['jabatan_terakhir'];
    alamatPerusahaan = json['alamat_perusahaan'];
    provinsi = json['provinsi'];
    kabupaten = json['kabupaten'];
    tanggalMulaiKerja = json['tanggal_mulai_kerja'];
    tanggalBerhentiKerja = json['tanggal_berhenti_kerja'];
    alasanBerhenti = json['alasan_berhenti'];
    lampiran = json['lampiran'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['nama_perusahaan'] = this.namaPerusahaan;
    data['jenis_perusahaan'] = this.jenisPerusahaan;
    data['jabatan_terakhir'] = this.jabatanTerakhir;
    data['alamat_perusahaan'] = this.alamatPerusahaan;
    data['provinsi'] = this.provinsi;
    data['kabupaten'] = this.kabupaten;
    data['tanggal_mulai_kerja'] = this.tanggalMulaiKerja;
    data['tanggal_berhenti_kerja'] = this.tanggalBerhentiKerja;
    data['alasan_berhenti'] = this.alasanBerhenti;
    data['lampiran'] = this.lampiran;
    return data;
  }
}

class Button {
  String? ubahData;
  String? hapusData;
  String? ajukanPerubahanData;
  String? ajukanData;
  String? catatanRevisi;
  String? btnTutup;
  String? btnBatal;
  String? btnYa;
  String? btnSend;

  Button(
      {this.ubahData,
        this.hapusData,
        this.ajukanPerubahanData,
        this.ajukanData,
        this.catatanRevisi,
        this.btnTutup,
        this.btnBatal,
        this.btnYa,
        this.btnSend});

  Button.fromJson(Map<String, dynamic> json) {
    ubahData = json['ubah_data'];
    hapusData = json['hapus_data'];
    ajukanPerubahanData = json['ajukan_perubahan_data'];
    ajukanData = json['ajukan_data'];
    catatanRevisi = json['catatan_revisi'];
    btnTutup = json['btn_tutup'];
    btnBatal = json['btn_batal'];
    btnYa = json['btn_ya'];
    btnSend = json['btn_send'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['ubah_data'] = this.ubahData;
    data['hapus_data'] = this.hapusData;
    data['ajukan_perubahan_data'] = this.ajukanPerubahanData;
    data['ajukan_data'] = this.ajukanData;
    data['catatan_revisi'] = this.catatanRevisi;
    data['btn_tutup'] = this.btnTutup;
    data['btn_batal'] = this.btnBatal;
    data['btn_ya'] = this.btnYa;
    data['btn_send'] = this.btnSend;
    return data;
  }
}

class Message {
  String? hapusData;
  String? pengajuanHapus;
  String? namaPerusahaanEmpty;
  String? jenisPerusahaanEmpty;
  String? jabatanTerakhirEmpty;
  String? alamatPerusahaanEmpty;
  String? provinsiEmpty;
  String? kabupatenEmpty;
  String? tanggalMulaiEmpty;
  String? tanggalSelesaiEmpty;
  String? alasanEmpty;

  Message(
      {this.hapusData,
        this.pengajuanHapus,
        this.namaPerusahaanEmpty,
        this.jenisPerusahaanEmpty,
        this.jabatanTerakhirEmpty,
        this.alamatPerusahaanEmpty,
        this.provinsiEmpty,
        this.kabupatenEmpty,
        this.tanggalMulaiEmpty,
        this.tanggalSelesaiEmpty,
        this.alasanEmpty});

  Message.fromJson(Map<String, dynamic> json) {
    hapusData = json['hapus_data'];
    pengajuanHapus = json['pengajuan_hapus'];
    namaPerusahaanEmpty = json['nama_perusahaan_empty'];
    jenisPerusahaanEmpty = json['jenis_perusahaan_empty'];
    jabatanTerakhirEmpty = json['jabatan_terakhir_empty'];
    alamatPerusahaanEmpty = json['alamat_perusahaan_empty'];
    provinsiEmpty = json['provinsi_empty'];
    kabupatenEmpty = json['kabupaten_empty'];
    tanggalMulaiEmpty = json['tanggal_mulai_empty'];
    tanggalSelesaiEmpty = json['tanggal_selesai_empty'];
    alasanEmpty = json['alasan_empty'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['hapus_data'] = this.hapusData;
    data['pengajuan_hapus'] = this.pengajuanHapus;
    data['nama_perusahaan_empty'] = this.namaPerusahaanEmpty;
    data['jenis_perusahaan_empty'] = this.jenisPerusahaanEmpty;
    data['jabatan_terakhir_empty'] = this.jabatanTerakhirEmpty;
    data['alamat_perusahaan_empty'] = this.alamatPerusahaanEmpty;
    data['provinsi_empty'] = this.provinsiEmpty;
    data['kabupaten_empty'] = this.kabupatenEmpty;
    data['tanggal_mulai_empty'] = this.tanggalMulaiEmpty;
    data['tanggal_selesai_empty'] = this.tanggalSelesaiEmpty;
    data['alasan_empty'] = this.alasanEmpty;
    return data;
  }
}
