import 'dart:convert';

PageBahasaModel pageBahasaModelFromJson(String str) => PageBahasaModel.fromJson(json.decode(str));

String pageBahasaModelToJson(PageBahasaModel data) => json.encode(data.toJson());

class PageBahasaModel {
  Bahasa? bahasa;

  PageBahasaModel({this.bahasa});

  PageBahasaModel.fromJson(Map<String, dynamic> json) {
    bahasa =
    json['bahasa'] != null ? new Bahasa.fromJson(json['bahasa']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.bahasa != null) {
      data['bahasa'] = this.bahasa!.toJson();
    }
    return data;
  }
}

class Bahasa {
  String? indonesia;
  String? english;

  Bahasa({this.indonesia, this.english});

  Bahasa.fromJson(Map<String, dynamic> json) {
    indonesia = json['indonesia'];
    english = json['english'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['indonesia'] = this.indonesia;
    data['english'] = this.english;
    return data;
  }
}
