import 'dart:convert';

PageAktivitasModel pageAktivitasModelFromJson(String str) => PageAktivitasModel.fromJson(json.decode(str));

String pageAktivitasModelToJson(PageAktivitasModel data) => json.encode(data.toJson());

class PageAktivitasModel {
  MenuAktivitas? menuAktivitas;

  PageAktivitasModel({this.menuAktivitas});

  PageAktivitasModel.fromJson(Map<String, dynamic> json) {
    menuAktivitas = json['menu_aktivitas'] != null
        ? new MenuAktivitas.fromJson(json['menu_aktivitas'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuAktivitas != null) {
      data['menu_aktivitas'] = this.menuAktivitas!.toJson();
    }
    return data;
  }
}

class MenuAktivitas {
  String? title;
  String? titleDetail;
  String? tabSaya;
  String? tabKaryawan;
  Data? data;
  Button? button;

  MenuAktivitas(
      {this.title, this.titleDetail, this.tabSaya, this.tabKaryawan, this.data, this.button});

  MenuAktivitas.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    titleDetail = json['title_detail'];
    tabSaya = json['tab_saya'];
    tabKaryawan = json['tab_karyawan'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    button =
    json['button'] != null ? new Button.fromJson(json['button']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['title_detail'] = this.titleDetail;
    data['tab_saya'] = this.tabSaya;
    data['tab_karyawan'] = this.tabKaryawan;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    return data;
  }
}

class Data {
  String? header;
  String? namaKaryawan;
  String? jabatan;
  String? cabang;
  String? departemen;
  String? keterangan;
  String? jam;
  String? lokasi;
  String? lokasiAktivitas;
  String? tanggal;
  String? akurasi;
  String? absensiAktivitas;
  String? meter;
  String? messagePermission;

  Data(
      {this.header,
        this.namaKaryawan,
        this.jabatan,
        this.cabang,
        this.departemen,
        this.keterangan,
        this.jam,
        this.lokasi,
        this.lokasiAktivitas,
        this.tanggal,
        this.akurasi,
        this.absensiAktivitas,
        this.meter,
        this.messagePermission});

  Data.fromJson(Map<String, dynamic> json) {
    header = json['header'];
    namaKaryawan = json['nama_karyawan'];
    jabatan = json['jabatan'];
    cabang = json['cabang'];
    departemen = json['departemen'];
    keterangan = json['keterangan'];
    jam = json['jam'];
    lokasi = json['lokasi'];
    lokasiAktivitas = json['lokasi_aktivitas'];
    tanggal = json['tanggal'];
    akurasi = json['akurasi'];
    absensiAktivitas = json['absensi_aktivitas'];
    meter = json['meter'];
    messagePermission = json['message_permission'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['header'] = this.header;
    data['nama_karyawan'] = this.namaKaryawan;
    data['jabatan'] = this.jabatan;
    data['cabang'] = this.cabang;
    data['departemen'] = this.departemen;
    data['keterangan'] = this.keterangan;
    data['jam'] = this.jam;
    data['lokasi'] = this.lokasi;
    data['lokasi_aktivitas'] = this.lokasiAktivitas;
    data['tanggal'] = this.tanggal;
    data['akurasi'] = this.akurasi;
    data['absensi_aktivitas'] = this.absensiAktivitas;
    data['meter'] = this.meter;
    data['message_permission'] = this.messagePermission;
    return data;
  }
}

class Button {
  String? btnAktivitas;
  String? btnCancel;
  String? btnClose;
  String? btnSubmit;

  Button({this.btnAktivitas, this.btnCancel, this.btnClose, this.btnSubmit});

  Button.fromJson(Map<String, dynamic> json) {
    btnAktivitas = json['btn_aktivitas'];
    btnCancel = json['btn_cancel'];
    btnClose = json['btn_close'];
    btnSubmit = json['btn_submit'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['btn_aktivitas'] = this.btnAktivitas;
    data['btn_cancel'] = this.btnCancel;
    data['btn_close'] = this.btnClose;
    data['btn_submit'] = this.btnSubmit;
    return data;
  }
}


