import 'dart:convert';

PageAbsensiModel pageAbsensiModelFromJson(String str) =>
    PageAbsensiModel.fromJson(json.decode(str));

String pageAbsensiModelToJson(PageAbsensiModel data) =>
    json.encode(data.toJson());

class PageAbsensiModel {
  Absensi? absensi;

  PageAbsensiModel({this.absensi});

  PageAbsensiModel.fromJson(Map<String, dynamic> json) {
    absensi =
        json['absensi'] != null ? new Absensi.fromJson(json['absensi']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.absensi != null) {
      data['absensi'] = this.absensi!.toJson();
    }
    return data;
  }
}

class Absensi {
  Data? data;
  Button? button;
  MessagePeringatan? messagePeringatan;

  Absensi({this.data, this.button, this.messagePeringatan});

  Absensi.fromJson(Map<String, dynamic> json) {
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    button =
        json['button'] != null ? new Button.fromJson(json['button']) : null;
    messagePeringatan = json['message_peringatan'] != null
        ? new MessagePeringatan.fromJson(json['message_peringatan'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    if (this.messagePeringatan != null) {
      data['message_peringatan'] = this.messagePeringatan!.toJson();
    }
    return data;
  }
}

class Data {
  String? lokasi;
  String? akurasi;
  String? jamKerja;
  String? jamIstirahat;
  String? keterangan;
  String? meter;
  String? registrasi;
  String? titlePeringatan;
  String? pilihJamKerja;
  String? hintSemuaJamKerja;
  String? jadwalKerjaAndaSaatIni;
  String? jamKerjaBelumDipilih;

  Data(
      {this.lokasi,
      this.akurasi,
      this.jamKerja,
      this.jamIstirahat,
      this.keterangan,
      this.meter,
      this.registrasi,
      this.titlePeringatan,
      this.pilihJamKerja,
      this.hintSemuaJamKerja,
      this.jadwalKerjaAndaSaatIni,
      this.jamKerjaBelumDipilih});

  Data.fromJson(Map<String, dynamic> json) {
    lokasi = json['lokasi'];
    akurasi = json['akurasi'];
    jamKerja = json['jam_kerja'];
    jamIstirahat = json['jam_istirahat'];
    keterangan = json['keterangan'];
    meter = json['meter'];
    registrasi = json['registrasi'];
    titlePeringatan = json['title_peringatan'];
    pilihJamKerja = json['pilih_jam_kerja'];
    hintSemuaJamKerja = json['hint_semua_jam_kerja'];
    jadwalKerjaAndaSaatIni = json['jadwal_kerja_saat_ini'];
    jamKerjaBelumDipilih = json['jam_kerja_belum_dipilih'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['lokasi'] = this.lokasi;
    data['akurasi'] = this.akurasi;
    data['jam_kerja'] = this.jamKerja;
    data['jam_istirahat'] = this.jamIstirahat;
    data['keterangan'] = this.keterangan;
    data['meter'] = this.meter;
    data['registrasi'] = this.registrasi;
    data['title_peringatan'] = this.titlePeringatan;
    data['pilih_jam_kerja'] = this.pilihJamKerja;
    data['hint_semua_jam_kerja'] = this.hintSemuaJamKerja;
    data['jadwal_kerja_saat_ini'] = this.jadwalKerjaAndaSaatIni;
    data['jam_kerja_belum_dipilih']=this.jamKerjaBelumDipilih;
    return data;
  }
}

class Button {
  String? btnMasuk;
  String? btnPulang;
  String? btnMulaiIst;
  String? btnSelesaiIst;
  String? btnCancel;
  String? btnClose;
  String? btnSubmit;
  String? btnModalBatal;
  String? btnModalLanjutkan;

  Button(
      {this.btnMasuk,
      this.btnPulang,
      this.btnMulaiIst,
      this.btnSelesaiIst,
      this.btnCancel,
      this.btnClose,
      this.btnSubmit,
      this.btnModalBatal,
      this.btnModalLanjutkan});

  Button.fromJson(Map<String, dynamic> json) {
    btnMasuk = json['btn_masuk'];
    btnPulang = json['btn_pulang'];
    btnMulaiIst = json['btn_mulai_ist'];
    btnSelesaiIst = json['btn_selesai_ist'];
    btnCancel = json['btn_cancel'];
    btnClose = json['btn_close'];
    btnSubmit = json['btn_submit'];
    btnModalBatal = json['btn_modal_batal'];
    btnModalLanjutkan = json['btn_modal_lanjutkan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['btn_masuk'] = this.btnMasuk;
    data['btn_pulang'] = this.btnPulang;
    data['btn_mulai_ist'] = this.btnMulaiIst;
    data['btn_selesai_ist'] = this.btnSelesaiIst;
    data['btn_cancel'] = this.btnCancel;
    data['btn_close'] = this.btnClose;
    data['btn_submit'] = this.btnSubmit;
    data['btn_modal_batal'] = this.btnModalBatal;
    data['btn_modal_lanjutkan'] = this.btnModalLanjutkan;
    return data;
  }
}

class MessagePeringatan {
  String? tidakBolehAbsen;
  String? kamera;
  String? hubungiAdmin;

  MessagePeringatan({this.tidakBolehAbsen, this.kamera, this.hubungiAdmin});

  MessagePeringatan.fromJson(Map<String, dynamic> json) {
    tidakBolehAbsen = json['tidak_boleh_absen'];
    kamera = json['kamera'];
    hubungiAdmin = json['hubungi_admin'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tidak_boleh_absen'] = this.tidakBolehAbsen;
    data['kamera'] = this.kamera;
    data['hubungi_admin'] = this.hubungiAdmin;
    return data;
  }
}
