// To parse this JSON data, do
//
//     final getListKpiTeamRespon = getListKpiTeamResponFromJson(jsonString);

import 'dart:convert';

GetListKpiTeamRespon getListKpiTeamResponFromJson(String str) =>
    GetListKpiTeamRespon.fromJson(json.decode(str));

String getListKpiTeamResponToJson(GetListKpiTeamRespon data) =>
    json.encode(data.toJson());

class GetListKpiTeamRespon {
  bool? success;
  String? message;
  List<DataKpiTeam>? data;

  GetListKpiTeamRespon({
    this.success,
    this.message,
    this.data,
  });

  factory GetListKpiTeamRespon.fromJson(Map<String, dynamic> json) =>
      GetListKpiTeamRespon(
        success: json["success"],
        message: json["message"],
        data: json["data"] == null
            ? null
            : List<DataKpiTeam>.from(
                json["data"].map((x) => DataKpiTeam.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataKpiTeam {
  String? idKaryawan;
  int? tahun;
  int? bulan;
  String? status;
  String? idAtasan;
  String? cttExitingRole;
  String? cttCareerDevelopment;
  String? cttDiterima;
  String? tglApproval;
  String? userApproval;
  String? idCompany;
  String? userInput;
  String? tglInput;
  String? userUpdate;
  String? tglUpdate;
  String? namaLengkap;
  String? jenis;
  String? jenisColor;
  String? jenisFontColor;

  DataKpiTeam(
      {this.idKaryawan,
      this.tahun,
      this.bulan,
      this.status,
      this.idAtasan,
      this.cttExitingRole,
      this.cttCareerDevelopment,
      this.cttDiterima,
      this.tglApproval,
      this.userApproval,
      this.idCompany,
      this.userInput,
      this.tglInput,
      this.userUpdate,
      this.tglUpdate,
      this.namaLengkap,
      this.jenis,
      this.jenisColor,
      this.jenisFontColor});

  factory DataKpiTeam.fromJson(Map<String, dynamic> json) => DataKpiTeam(
      idKaryawan: json["id_karyawan"],
      tahun: json["tahun"],
      bulan: json["bulan"],
      status: json["status"],
      idAtasan: json["id_atasan"],
      cttExitingRole: json["ctt_exiting_role"],
      cttCareerDevelopment: json["ctt_career_development"],
      cttDiterima: json["ctt_diterima"],
      tglApproval: json["tgl_approval"],
      userApproval: json["user_approval"],
      idCompany: json["id_company"],
      userInput: json["user_input"],
      tglInput: json["tgl_input"],
      userUpdate: json["user_update"],
      tglUpdate: json["tgl_update"],
      namaLengkap: json["nama_lengkap"],
      jenis: json["jenis"],
      jenisColor: json["jenis_color"],
      jenisFontColor: json['jenis_font_color']);

  Map<String, dynamic> toJson() => {
        "id_karyawan": idKaryawan,
        "tahun": tahun,
        "bulan": bulan,
        "status": status,
        "id_atasan": idAtasan,
        "ctt_exiting_role": cttExitingRole,
        "ctt_career_development": cttCareerDevelopment,
        "ctt_diterima": cttDiterima,
        "tgl_approval": tglApproval,
        "user_approval": userApproval,
        "id_company": idCompany,
        "user_input": userInput,
        "tgl_input": tglInput,
        "user_update": userUpdate,
        "tgl_update": tglUpdate,
        "nama_lengkap": namaLengkap,
        "jenis": jenis,
        "jenis_color": jenisColor,
        "jenis_font_color": jenisFontColor
      };
}
