// To parse this JSON data, do
//
//     final responlistKpi = responlistKpiFromJson(jsonString);

import 'dart:convert';

ResponlistKpi responlistKpiFromJson(String str) =>
    ResponlistKpi.fromJson(json.decode(str));

String responlistKpiToJson(ResponlistKpi data) => json.encode(data.toJson());

class ResponlistKpi {
  bool? success;
  String? message;
  List<DataKpi>? data;

  ResponlistKpi({
    this.success,
    this.message,
    this.data,
  });

  factory ResponlistKpi.fromJson(Map<String, dynamic> json) => ResponlistKpi(
        success: json["success"],
        message: json["message"],
        data: json["data"] == null ? null :List<DataKpi>.from(json["data"].map((x) => DataKpi.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": data == null ? null :List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataKpi {
  String? idKaryawan;
  String? idCompany;
  String? nama;
  int? tahun;
  int? bulan;
  bool? dataLampau;
  String? status;
  String? jenis;
  String? jenisColor;
  String? jenisFontColor;

  DataKpi({
    this.idKaryawan,
    this.idCompany,
    this.nama,
    this.tahun,
    this.bulan,
    this.dataLampau,
    this.status,
    this.jenis,
    this.jenisColor,
    this.jenisFontColor,
  });

  factory DataKpi.fromJson(Map<String, dynamic> json) => DataKpi(
        idKaryawan: json["id_karyawan"],
        idCompany: json["id_company"],
        nama: json["nama"],
        tahun: json["tahun"],
        bulan: json["bulan"],
        dataLampau: json["data_lampau"],
        status: json["status"],
        jenis: json["jenis"],
        jenisColor: json["jenis_color"],
        jenisFontColor: json["jenis_font_color"],
      );

  Map<String, dynamic> toJson() => {
        "id_karyawan": idKaryawan,
        "id_company": idCompany,
        "nama": nama,
        "tahun": tahun,
        "bulan": bulan,
        "data_lampau":dataLampau,
        "status": status,
        "jenis": jenis,
        "jenis_color": jenisColor,
        "jenis_font_color": jenisFontColor,
      };
}
