// To parse this JSON data, do
//
//     final dataPengajuanNilaiIndividu = dataPengajuanNilaiIndividuFromJson(jsonString);

import 'dart:convert';

DataPengajuanNilaiIndividu dataPengajuanNilaiIndividuFromJson(String str) =>
    DataPengajuanNilaiIndividu.fromJson(json.decode(str));

String dataPengajuanNilaiIndividuToJson(DataPengajuanNilaiIndividu data) =>
    json.encode(data.toJson());

class DataPengajuanNilaiIndividu {
  bool? success;
  String? message;
  DataNilaiIndividu? data;

  DataPengajuanNilaiIndividu({
    this.success,
    this.message,
    this.data,
  });

  factory DataPengajuanNilaiIndividu.fromJson(Map<String, dynamic> json) =>
      DataPengajuanNilaiIndividu(
        success: json["success"],
        message: json["message"],
        data: json['data'] == null
            ? null
            : DataNilaiIndividu.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": data == null ? null : data!.toJson(),
      };
}

class DataNilaiIndividu {
  InformasiSkor? informasiSkor;
  List<InformasiGrade>? informasiGrade;
  InformasiKomponen? informasiKomponen;
  InformasiCtt? informasiCtt;

  DataNilaiIndividu({
    this.informasiSkor,
    this.informasiGrade,
    this.informasiKomponen,
    this.informasiCtt,
  });

  factory DataNilaiIndividu.fromJson(Map<String, dynamic> json) =>
      DataNilaiIndividu(
        informasiSkor: json["informasi_skor"] == null
            ? null
            : InformasiSkor.fromJson(json["informasi_skor"]),
        informasiGrade: json["informasi_grade"] == null
            ? []
            : List<InformasiGrade>.from(
                json["informasi_grade"].map((x) => InformasiGrade.fromJson(x))),
        informasiKomponen: json["informasi_komponen"] == null
            ? null
            : InformasiKomponen.fromJson(json["informasi_komponen"]),
        informasiCtt: json["informasi_ctt"] == null
            ? null
            : InformasiCtt.fromJson(json["informasi_ctt"]),
      );

  Map<String, dynamic> toJson() => {
        "informasi_skor": informasiSkor?.toJson(),
        "informasi_grade": informasiGrade == null
            ? null
            : List<dynamic>.from(informasiGrade!.map((x) => x.toJson())),
        "informasi_komponen":
            informasiKomponen == null ? null : informasiKomponen?.toJson(),
      };
}

class InformasiGrade {
  String? grade;
  String? keterangan;
  String? batasBawah;
  String? batasAtas;
  String? idCompany;
  String? userInput;
  String? tglInput;
  String? userUpdate;
  String? tglUpdate;

  InformasiGrade({
    this.grade,
    this.keterangan,
    this.batasBawah,
    this.batasAtas,
    this.idCompany,
    this.userInput,
    this.tglInput,
    this.userUpdate,
    this.tglUpdate,
  });

  factory InformasiGrade.fromJson(Map<String, dynamic> json) => InformasiGrade(
        grade: json["grade"],
        keterangan: json["keterangan"],
        batasBawah: json["batas_bawah"],
        batasAtas: json["batas_atas"],
        idCompany: json["id_company"],
        userInput: json["user_input"],
        tglInput: json["tgl_input"],
        userUpdate: json["user_update"],
        tglUpdate: json["tgl_update"],
      );

  Map<String, dynamic> toJson() => {
        "grade": grade,
        "keterangan": keterangan,
        "batas_bawah": batasBawah,
        "batas_atas": batasAtas,
        "id_company": idCompany,
        "user_input": userInput,
        "tgl_input": tglInput,
        "user_update": userUpdate,
        "tgl_update": tglUpdate,
      };
}

class InformasiSkor {
  String? aspekKinerjaNm;
  String? apsekKinerjaAktual;
  String? aspekKinerjaBobot;
  String? aspekKinerjaSkor;
  String? aspekKepribadianNm;
  String? aspekKepribadianAktual;
  String? aspekKepribadianBobot;
  String? aspekKepribadianSkor;
  String? aspekKedisiplinanNm;
  String? aspekKedisiplinanAktual;
  String? aspekKedisiplinanBobot;
  String? aspekKedisiplinanSkor;
  String? remark;
  String? totalNilai;
  String? predikat;

  InformasiSkor({
    this.aspekKinerjaNm,
    this.apsekKinerjaAktual,
    this.aspekKinerjaBobot,
    this.aspekKinerjaSkor,
    this.aspekKepribadianNm,
    this.aspekKepribadianAktual,
    this.aspekKepribadianBobot,
    this.aspekKepribadianSkor,
    this.aspekKedisiplinanNm,
    this.aspekKedisiplinanAktual,
    this.aspekKedisiplinanBobot,
    this.aspekKedisiplinanSkor,
    this.remark,
    this.totalNilai,
    this.predikat,
  });

  factory InformasiSkor.fromJson(Map<String, dynamic> json) => InformasiSkor(
        aspekKinerjaNm: json["aspek_kinerja_nm"],
        apsekKinerjaAktual: json["aspek_kinerja_aktual"],
        aspekKinerjaBobot: json["aspek_kinerja_bobot"],
        aspekKinerjaSkor: json["aspek_kinerja_skor"],
        aspekKepribadianNm: json["aspek_kepribadian_nm"],
        aspekKepribadianAktual: json["aspek_kepribadian_aktual"],
        aspekKepribadianBobot: json["aspek_kepribadian_bobot"],
        aspekKepribadianSkor: json["aspek_kepribadian_skor"],
        aspekKedisiplinanNm: json["aspek_kedisiplinan_nm"],
        aspekKedisiplinanAktual: json["aspek_kedisiplinan_aktual"],
        aspekKedisiplinanBobot: json["aspek_kedisiplinan_bobot"],
        aspekKedisiplinanSkor: json["aspek_kedisiplinan_skor"],
        remark: json['remark'],
        totalNilai: json["total_nilai"],
        predikat: json["predikat"],
      );

  Map<String, dynamic> toJson() => {
        "aspek_kinerja_nm": aspekKinerjaNm,
        "aspek_kinerja_aktual":apsekKinerjaAktual,
        "aspek_kinerja_bobot":aspekKinerjaBobot,
        "aspek_kinerja_skor": aspekKinerjaSkor,
        "aspek_kepribadian_nm": aspekKepribadianNm,
        "aspek_kepribadian_aktual":aspekKepribadianAktual,
        "aspek_kepribadian_bobot":aspekKepribadianBobot,
        "aspek_kepribadian_skor": aspekKepribadianSkor,
        "aspek_kedisiplinan_nm": aspekKedisiplinanNm,
        "aspek_kedisiplinan_aktual":aspekKedisiplinanAktual,
        "aspek_kedisiplinan_bobot":aspekKedisiplinanBobot,
        "aspek_kedisiplinan_skor": aspekKedisiplinanSkor,
        "remark": remark,
        "total_nilai": totalNilai,
        "predikat": predikat,
      };
}

class InformasiCtt {
  String? cttExitingRole;
  String? cttCareerDevelopment;
  String? cttDiterima;

  InformasiCtt(
      {this.cttExitingRole, this.cttCareerDevelopment, this.cttDiterima});

  factory InformasiCtt.fromJson(Map<String, dynamic> json) => InformasiCtt(
        cttExitingRole:
            json["ctt_exiting_role"] == null ? null : json["ctt_exiting_role"],
        cttCareerDevelopment: json["ctt_career_development"] == null
            ? null
            : json["ctt_career_development"],
        cttDiterima: json["ctt_diterima"] == null ? null : json["ctt_diterima"],
      );

  Map<String, dynamic> toJson() => {
        "ctt_exiting_role": cttExitingRole == null ? null : cttExitingRole,
        "ctt_career_development":
            cttCareerDevelopment == null ? null : cttCareerDevelopment,
        "ctt_diterima": cttDiterima == null ? null : cttDiterima,
      };
}

class InformasiKomponen {
  int? perfomance;
  int? kepribadian;
  bool? button;
  bool? ignorePointer;
  String? ketPeriode;

  InformasiKomponen(
      {this.perfomance,
      this.kepribadian,
      this.button,
      this.ignorePointer,
      this.ketPeriode});

  factory InformasiKomponen.fromJson(Map<String, dynamic> json) =>
      InformasiKomponen(
          perfomance: json["perfomance"] == null ? null : json['perfomance'],
          kepribadian: json["kepribadian"] == null ? null : json['kepribadian'],
          button: json["button"] == null ? null : json['button'],
          ignorePointer:
              json["ignore_pointer"] == null ? null : json['ignore_pointer'],
          ketPeriode: json["ket_periode"] == null ? null : json['ket_periode']);

  Map<String, dynamic> toJson() => {
        "perfomance": perfomance == null ? null : perfomance,
        "kepribadian": kepribadian == null ? null : kepribadian,
        "button": button == null ? null : button,
        "ignore_pointer": ignorePointer == null ? null : ignorePointer,
        "ket_periode": ketPeriode == null ? null : ketPeriode
      };
}
