// To parse this JSON data, do
//
//     final kontakPegawaiRespon = kontakPegawaiResponFromJson(jsonString);

import 'dart:convert';

KontakPegawaiRespon kontakPegawaiResponFromJson(String str) =>
    KontakPegawaiRespon.fromJson(json.decode(str));

String kontakPegawaiResponToJson(KontakPegawaiRespon data) =>
    json.encode(data.toJson());

class KontakPegawaiRespon {
  bool? success;
  String? message;
  List<DataKontak>? data;

  KontakPegawaiRespon({
    this.success,
    this.message,
    this.data,
  });

  factory KontakPegawaiRespon.fromJson(Map<String, dynamic> json) =>
      KontakPegawaiRespon(
        success: json["success"],
        message: json["message"],
        data: json['data'] == null
            ? null
            : List<DataKontak>.from(
                json["data"].map((x) => DataKontak.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": data == null
            ? null
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataKontak {
  String? idKaryawan;
  String? namaLengkap;
  String? nik;
  String? telepon;
  String? linkTelepon;
  String? email;
  String? foto;
  bool? buttonWa;
  bool? buttonEmail;
  DataKontak({
    this.idKaryawan,
    this.namaLengkap,
    this.nik,
    this.telepon,
    this.linkTelepon,
    this.email,
    this.foto,
    this.buttonWa,
    this.buttonEmail,
  });

  factory DataKontak.fromJson(Map<String, dynamic> json) => DataKontak(
        idKaryawan: json["id_karyawan"] == null ? null : json['id_karyawan'],
        namaLengkap: json["nama_lengkap"] == null ? null : json['nama_lengkap'],
        nik: json["nik"] == null ? null : json['nik'],
        telepon: json["telepon"] == null ? null : json['telepon'],
        linkTelepon: json["link_telepon"] == null ? null : json['link_telepon'],
        email: json["email"] == null ? null : json['email'],
        foto: json["foto"] == null ? null : json['foto'],
        buttonWa: json["button_wa"] == null ? null : json['button_wa'],
        buttonEmail: json["button_email"] == null ? null : json['button_email'],
      );

  Map<String, dynamic> toJson() => {
        "id_karyawan": idKaryawan == null ? null : idKaryawan,
        "nama_lengkap": namaLengkap == null ? null : namaLengkap,
        "nik": nik == null ? null : nik,
        "telepon": telepon == null ? null : telepon,
        "link_telepon": linkTelepon == null ? null : linkTelepon,
        "email": email == null ? null : email,
        "foto": foto == null ? null : foto,
        "button_wa": buttonWa == null ? null : buttonWa,
        "button_email": buttonEmail == null ? null : buttonEmail,
      };
}
