import 'dart:convert';

DataKelengkapanFileRespon dataKelengkapanFileResponFromJson(String str) => DataKelengkapanFileRespon.fromJson(json.decode(str));

String dataKelengkapanFileResponToJson(DataKelengkapanFileRespon data) => json.encode(data.toJson());

class DataKelengkapanFileRespon {
  bool? success;
  String? message;
  List<DataDatakelengkapanfile>? dataDatakelengkapanfile;

  DataKelengkapanFileRespon(
      {this.success, this.message, this.dataDatakelengkapanfile});

  DataKelengkapanFileRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data_datakelengkapanfile'] != null) {
      dataDatakelengkapanfile = <DataDatakelengkapanfile>[];
      json['data_datakelengkapanfile'].forEach((v) {
        dataDatakelengkapanfile!.add(new DataDatakelengkapanfile.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataDatakelengkapanfile != null) {
      data['data_datakelengkapanfile'] =
          this.dataDatakelengkapanfile!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataDatakelengkapanfile {
  String? idKelengkapanFile;
  String? idKaryawan;
  String? title;
  String? namaDokumen;
  String? file;
  String? idCompany;
  String? statusPengajuan;
  String? colorStatusPengajuan;
  bool? buttonRevisi;
  String? ketRevisi;

  DataDatakelengkapanfile(
      {this.idKelengkapanFile,
        this.idKaryawan,
        this.title,
        this.namaDokumen,
        this.file,
        this.idCompany,
        this.statusPengajuan,
        this.colorStatusPengajuan,
        this.buttonRevisi,
        this.ketRevisi});

  DataDatakelengkapanfile.fromJson(Map<String, dynamic> json) {
    idKelengkapanFile = json['id_kelengkapan_file'];
    idKaryawan = json['id_karyawan'];
    title = json['title'];
    namaDokumen = json['nama_dokumen'];
    file = json['file'];
    idCompany = json['id_company'];
    statusPengajuan = json['status_pengajuan'];
    colorStatusPengajuan = json['color_status_pengajuan'];
    buttonRevisi = json['button_revisi'];
    ketRevisi = json['ket_revisi'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_kelengkapan_file'] = this.idKelengkapanFile;
    data['id_karyawan'] = this.idKaryawan;
    data['title'] = this.title;
    data['nama_dokumen'] = this.namaDokumen;
    data['file'] = this.file;
    data['id_company'] = this.idCompany;
    data['status_pengajuan'] = this.statusPengajuan;
    data['color_status_pengajuan'] = this.colorStatusPengajuan;
    data['button_revisi'] = this.buttonRevisi;
    data['ket_revisi'] = this.ketRevisi;
    return data;
  }
}
