import 'dart:convert';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';

DataPendidikanByIdRespon dataPendidikanByIdResponFromJson(String str) => DataPendidikanByIdRespon.fromJson(json.decode(str));

String dataPendidikanByIdResponToJson(DataPendidikanByIdRespon data) => json.encode(data.toJson());

class DataPendidikanByIdRespon {
  bool? success;
  String? message;
  List<DataDatapendidikanById>? dataDatapendidikan;

  DataPendidikanByIdRespon(
      {this.success, this.message, this.dataDatapendidikan});

  DataPendidikanByIdRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data_datapendidikan'] != null) {
      dataDatapendidikan = <DataDatapendidikanById>[];
      json['data_datapendidikan'].forEach((v) {
        dataDatapendidikan!.add(new DataDatapendidikanById.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataDatapendidikan != null) {
      data['data_datapendidikan'] =
          this.dataDatapendidikan!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataDatapendidikanById {
  String? idPendidikan;
  String? idKaryawan;
  String? namaSekolah;
  JenisData? jenjang;
  String? jurusan;
  JenisData? lulusanAsal;
  String? gelar;
  String? tahunMasuk;
  String? tahunLulus;
  String? ijazah;
  String? transkrip;
  String? idCompany;

  DataDatapendidikanById(
      {this.idPendidikan,
        this.idKaryawan,
        this.namaSekolah,
        this.jenjang,
        this.jurusan,
        this.lulusanAsal,
        this.gelar,
        this.tahunMasuk,
        this.tahunLulus,
        this.ijazah,
        this.transkrip,
        this.idCompany});

  DataDatapendidikanById.fromJson(Map<String, dynamic> json) {
    idPendidikan = json['id_pendidikan'];
    idKaryawan = json['id_karyawan'];
    namaSekolah = json['nama_sekolah'];
    jenjang =
    json['jenjang'] != null ? new JenisData.fromJson(json['jenjang']) : null;
    jurusan = json['jurusan'];
    lulusanAsal = json['lulusan_asal'] != null
        ? new JenisData.fromJson(json['lulusan_asal'])
        : null;
    gelar = json['gelar'];
    tahunMasuk = json['tahun_masuk'];
    tahunLulus = json['tahun_lulus'];
    ijazah = json['ijazah'];
    transkrip = json['transkrip'];
    idCompany = json['id_company'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_pendidikan'] = this.idPendidikan;
    data['id_karyawan'] = this.idKaryawan;
    data['nama_sekolah'] = this.namaSekolah;
    if (this.jenjang != null) {
      data['jenjang'] = this.jenjang!.toJson();
    }
    data['jurusan'] = this.jurusan;
    if (this.lulusanAsal != null) {
      data['lulusan_asal'] = this.lulusanAsal!.toJson();
    }
    data['gelar'] = this.gelar;
    data['tahun_masuk'] = this.tahunMasuk;
    data['tahun_lulus'] = this.tahunLulus;
    data['ijazah'] = this.ijazah;
    data['transkrip'] = this.transkrip;
    data['id_company'] = this.idCompany;
    return data;
  }
}
