import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/SummaryApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SummaryRekapIzinEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getSummaryRekapIzinEvent extends SummaryRekapIzinEvent {
  ModelFilter? modelFilter;
  getSummaryRekapIzinEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

abstract class SummaryRekapIzinState {
  DataSummary? data;
}

class getSummaryRekapIzinSuccessState extends SummaryRekapIzinState {
  getSummaryRekapIzinSuccessState(
      SummaryRekapIzinEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummaryProgressRekapIzinState extends SummaryRekapIzinState {}

class SummaryErrorState extends SummaryRekapIzinState {}

class SummaryRekapIzinBloc
    extends Bloc<SummaryRekapIzinEvent, SummaryRekapIzinState> {
  SummaryRekapIzinState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SummaryRekapIzinBloc(SummaryRekapIzinState initialState)
      : super(initialState);

  @override
  Stream<SummaryRekapIzinState> mapEventToState(
      SummaryRekapIzinEvent event) async* {
    if (event is getSummaryRekapIzinEvent) {
      yield SummaryProgressRekapIzinState();
      modelFilter = event.modelFilter;
      SummaryRespon summaryRespon =
          await SummaryApi().getDataSummaryRekap(modelFilter,'summary/izin');
      if (summaryRespon.success!) {
        listSummary = summaryRespon.data;
        yield getSummaryRekapIzinSuccessState(event, listSummary);
      } else
        yield SummaryErrorState();
    }
  }
}
