import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/SummaryApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class SummaryRekapCutiEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getSummaryRekapCutiEvent extends SummaryRekapCutiEvent {
  ModelFilter? modelFilter;
  getSummaryRekapCutiEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

abstract class SummaryRekapCutiState {
  DataSummary? data;
}

class getSummaryRekapCutiSuccessState extends SummaryRekapCutiState {
  getSummaryRekapCutiSuccessState(
      SummaryRekapCutiEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummaryProgressCutiState extends SummaryRekapCutiState {}

class SummaryErrorState extends SummaryRekapCutiState {}

class SummaryRekapCutiBloc
    extends Bloc<SummaryRekapCutiEvent, SummaryRekapCutiState> {
  SummaryRekapCutiState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SummaryRekapCutiBloc(SummaryRekapCutiState initialState)
      : super(initialState);

  @override
  Stream<SummaryRekapCutiState> mapEventToState(
      SummaryRekapCutiEvent event) async* {
    if (event is getSummaryRekapCutiEvent) {
      yield SummaryProgressCutiState();
      modelFilter = event.modelFilter;
      SummaryRespon summaryRespon =
          await SummaryApi().getDataSummaryRekap(modelFilter,'summary/cuti');
      if (summaryRespon.success!) {
        listSummary = summaryRespon.data;
        yield getSummaryRekapCutiSuccessState(event, listSummary);
      } else
        yield SummaryErrorState();
    }
  }
}
