import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSummary.dart';
import 'package:absenkuv3/Repository/Service/dashboardApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class IzinSummaryEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getIzinSummaryEvent extends IzinSummaryEvent {
  ModelFilter? modelFilter;
  getIzinSummaryEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

class GetDataIzinDashboardEvent extends IzinSummaryEvent {
  GetDataIzinDashboardEvent(BuildContext _context) {
    context = _context;
  }
}

abstract class IzinSummaryState {
  DataSummary? data;
}

class getSummarySuccessState extends IzinSummaryState {
  getSummarySuccessState(IzinSummaryEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class getIzinDashboardSuccessState extends IzinSummaryState {
  getIzinDashboardSuccessState(IzinSummaryEvent _event, DataSummary? _data) {
    data = _data;
  }
}

class SummaryIzinProgressState extends IzinSummaryState {}

class LoadMoreProgressState extends IzinSummaryState {
  LoadMoreProgressState(DataSummary _data) {
    data = _data;
  }
}

class SummaryIzinErrorState extends IzinSummaryState {}

class SummaryIzinBloc extends Bloc<IzinSummaryEvent, IzinSummaryState> {
  IzinSummaryState? initialState;
  DataSummary? listSummary;
  ModelFilter? modelFilter;

  SummaryIzinBloc(IzinSummaryState initialState) : super(initialState);

  @override
  Stream<IzinSummaryState> mapEventToState(IzinSummaryEvent event) async* {
    if (event is GetDataIzinDashboardEvent) {
      yield SummaryIzinProgressState();
      SummaryRespon izin = await DashboardApi().getIzin();
      if (izin.success!) {
        listSummary = izin.data;
        yield getIzinDashboardSuccessState(event, listSummary);
      } else {
        yield SummaryIzinErrorState();
      }
    }
  }
}
