// ignore_for_file: deprecated_member_use

import 'dart:async';
import 'dart:io';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/Service/splashScreenApi.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:absenkuv3/Repository/DeviceInfo.dart';
import 'package:absenkuv3/Setting/security_service.dart';
import 'package:absenkuv3/UI/Template/dialog/dialogUpdateApp.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:url_launcher/url_launcher.dart';
import 'package:absenkuv3/Repository/Model/mDeviceInfo.dart';
import 'NavigatorBloc.dart';

abstract class SplashScreenEvent {
  BuildContext? context;
}

class InitStateEvent extends SplashScreenEvent {
  String? sourceInstaller;
  InitStateEvent(BuildContext _context, String _sourceInstaller) {
    context = _context;
    sourceInstaller = _sourceInstaller;
  }
}

class VersionAppEvent extends SplashScreenEvent {
  VersionAppEvent(BuildContext _context) {
    context = _context;
  }
}

class SplashScreenBloc extends Bloc<SplashScreenEvent, String?> {
  SplashScreenBloc() : super(null);

  @override
  Stream<String> mapEventToState(SplashScreenEvent event) async* {
    if (event is InitStateEvent) {
      LoginRespon? data = await sharedPreferences().getUserData();
      MDeviceinfo mDeviceInfo = await DeviceInfo().getDeviceInfo();
      int versiMobile = ServerInfo.versionCode;
      VersionRespon versionRespon = await SplashScreenApi()
          .cekVersionV2(versiMobile, mDeviceInfo.os, event.sourceInstaller);
      if (versionRespon.success!) {
        // UPDATE APK
        showDialog(
          barrierDismissible: false,
          context: event.context!,
          builder: (BuildContext context) => DialogUpdateApp(
            data: versionRespon,
            onClick: () {
              launcherUrl(versionRespon.version!.linkUpdate!);
            },
            onClickSkip: () {
              if (data.dataLogin != null) {
                if (data.dataLogin!.klien!) {
                  BlocProvider.of<NavigatorBloc>(event.context!)
                      .add(NavigateRemoveToDashboardKlien(event.context));
                } else {
                  BlocProvider.of<NavigatorBloc>(event.context!)
                      .add(NavigateRemoveToDashboard(event.context));
                }
              } else {
                BlocProvider.of<NavigatorBloc>(event.context!)
                    .add(NavigateRemoveToLogin(event.context));
              }
            },
          ),
        );
      } else {
        if (versionRespon.source!) {
          bool isDev = false;
          if (Platform.isAndroid) {
            isDev = await SecurityService.isDeveloperModeEnabled();
          }

          if (isDev && !ServerInfo.bolehDevelopermod) {
            versionRespon = VersionRespon(
                success: false,
                message: "PERINGATAN",
                source: versionRespon.source,
                messageSource: "<b>${ServerInfo.messageDeveloperMode} </b>");
            showDialog(
              barrierDismissible: false,
              context: event.context!,
              builder: (BuildContext context) => DialogSource(
                  data: versionRespon,
                  onClick: () {
                    Navigator.pop(context);
                    exit(0);
                  }),
            );
          } else {
            if (data.dataLogin != null) {
              if (data.dataLogin!.klien!) {
                BlocProvider.of<NavigatorBloc>(event.context!)
                    .add(NavigateRemoveToDashboardKlien(event.context));
              } else {
                BlocProvider.of<NavigatorBloc>(event.context!)
                    .add(NavigateRemoveToDashboard(event.context));
              }
            } else {
              BlocProvider.of<NavigatorBloc>(event.context!)
                  .add(NavigateRemoveToLogin(event.context));
            }
          }
        } else {
          showDialog(
            barrierDismissible: false,
            context: event.context!,
            builder: (BuildContext context) => DialogSource(
              data: versionRespon,
              onClick: () {
                Navigator.pop(context);
                exit(0);
              },
            ),
          );
        }
      }
      // });
    } else if (event is VersionAppEvent) {
      String versiMobile = ServerInfo.versionName;
      BasicRespon versionRespon =
          await SplashScreenApi().versionApp(versiMobile);
      debugPrint(versionRespon.message);
    }
  }

  launcherUrl(String link) async {
    // if (await canLaunch(link)) {
    await launch(link);
    // } else {
    //   throw 'Could not launch $link';
    // }
  }
}
