import 'package:absenkuv3/Repository/Model/mSos.dart';
import 'package:absenkuv3/Repository/Service/sosApi.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class DetailSosEvent {}

class GetDetailSos extends DetailSosEvent {
  String? idSos;
  GetDetailSos(this.idSos);
}

abstract class DetailSosState {}

class DetailSosProgress extends DetailSosState {}

class DetailSosSuccess extends DetailSosState {
  SosRespon sosRespon;
  DetailSosSuccess(this.sosRespon);
}

class DetailSosError extends DetailSosState {}

class DetailSosBloc extends Bloc<DetailSosEvent, DetailSosState> {
  DetailSosBloc(DetailSosState initialState) : super(initialState);

  @override
  Stream<DetailSosState> mapEventToState(DetailSosEvent event) async* {
    if (event is GetDetailSos) {
      yield DetailSosProgress();
      SosRespon sosRespon =
          await SosApi().getDetailDataSos(event.idSos, 'sosDetail');
      if (sosRespon.success!)
        yield DetailSosSuccess(sosRespon);
      else
        yield DetailSosError();
    }
  }
}
