import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSlipGaji.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/GajiApi.dart';
import 'package:absenkuv3/Repository/Service/userApi.dart';
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerBloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';
import '../CustomFunction.dart';

abstract class SlipGajiEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class GetSlipGajiEvent extends SlipGajiEvent{
  ModelFilter modelFilter;
  GetSlipGajiEvent(BuildContext _context, this.modelFilter){
    context = _context;
  }
}

class InitPasswordEvent extends SlipGajiEvent{}

class CekPasswordEvent extends SlipGajiEvent{
  String password;
  CekPasswordEvent(BuildContext _context, this.password){
    context = _context;
  }
}

abstract class SlipGajiState{
  DataSlipGaji? data;
}

class CekPasswordTrueState extends SlipGajiState{
  CekPasswordTrueState(SlipGajiEvent event){
    Future.delayed(Duration(milliseconds: 600)).then((value) {
      BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
      BlocProvider.of<MonthPickerBloc>(event.context!)
          .add(SetDate(null));
      // BlocProvider.of<NavigatorBloc>(event.context!).add(NavigateToSlipGaji(event.context));
    });

  }
}

class CekPasswordFalseState extends SlipGajiState{
  String? message;
  CekPasswordFalseState(SlipGajiEvent event, this.message);
}

class InitPasswordState extends SlipGajiState{}

class GetSlipGajiSuccessState extends SlipGajiState{
  GetSlipGajiSuccessState(SlipGajiEvent _event, DataSlipGaji? _data){
    data = _data;
  }
}

class SlipGajiProgressState extends SlipGajiState{}

class SlipGajiErrorState extends SlipGajiState{}

class SlipGajiBloc extends Bloc<SlipGajiEvent, SlipGajiState>{
  SlipGajiState? initialState;
  DataSlipGaji? dataSlipGaji;

  SlipGajiBloc(SlipGajiState initialState) : super(initialState);

  @override
  Stream<SlipGajiState> mapEventToState(SlipGajiEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetSlipGajiEvent){
      yield SlipGajiProgressState();
      SlipGajiRespon slipGajiRespon = await GajiApi().getDataSlipGaji(event.modelFilter);
      if(slipGajiRespon.success!){
        dataSlipGaji = slipGajiRespon.dataSlipGaji;
        yield GetSlipGajiSuccessState(event, dataSlipGaji);
      }
      else yield SlipGajiErrorState();
    }
    else if(event is InitPasswordEvent) yield InitPasswordState();
    else if(event is CekPasswordEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd);
      BasicRespon basicRespon = await UserApi().cekPassword(event.password);
      ProgressDialogDelayed.hide(pd);
      if(basicRespon.success!) yield CekPasswordTrueState(event);
      else yield CekPasswordFalseState(event, basicRespon.message);
    }
  }
}