import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mShift2.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/Service/shiftApi.dart';
import 'package:absenkuv3/Repository/Service/tukarShiftApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../Repository/Model/mPengajuanSaya.dart';

abstract class TukarShiftDetailEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class GetListTukarShiftDetailEvent extends TukarShiftDetailEvent{
  String? idPengajuan;
  String? konteks;
  GetListTukarShiftDetailEvent(BuildContext _context, this.idPengajuan, this.konteks){
    context = _context;
  }
}


abstract class TukarShiftDetailState{
  List<DataPengajuanSaya>? data;

}

class GetShiftDetailSuccessState extends TukarShiftDetailState{
  GetShiftDetailSuccessState(TukarShiftDetailEvent _event, List<DataPengajuanSaya>? _data){
    data = _data;
  }
}

class TukarShiftDetailProgressState extends TukarShiftDetailState{}


class DetailTukarShiftErrorState extends TukarShiftDetailState{}

class TukarShiftDetailBloc extends Bloc<TukarShiftDetailEvent, TukarShiftDetailState>{
  // TukarShiftDetailState? initialState;
  // List<DataShiftTeman>? listShiftTeman;
  // ModelFilter? modelFilter;
  // String? idMasterShift;
  // String? tanggal;
  // int offset = 0;
  // int limit = ServerInfo.limit;

  TukarShiftDetailBloc(TukarShiftDetailState initialState) : super(initialState);

  @override
  Stream<TukarShiftDetailState> mapEventToState(TukarShiftDetailEvent event) async*{
    if(event is GetListTukarShiftDetailEvent){
      yield TukarShiftDetailProgressState();
      PengajuanSaya shiftTemanRespon = await TukarShiftApi().getPengajuanSayaDetail(event.idPengajuan, event.konteks!);
      if(shiftTemanRespon.success!){
        yield GetShiftDetailSuccessState(event, shiftTemanRespon.data!);
      }
      else yield DetailTukarShiftErrorState();
    }
  }
}