import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mAktivitas.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mShift2.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/aktivitasApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/Service/shiftApi.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../CustomFunction.dart';
import 'package:intl/intl.dart';

abstract class ShiftKaryawanDetailEvent{
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class GetListShiftKaryawanDetailEvent extends ShiftKaryawanDetailEvent{
  ModelFilter? modelFilter;
  String? idMasterShift;
  String? tanggal;
  GetListShiftKaryawanDetailEvent(BuildContext _context, this.modelFilter, this.idMasterShift, this.tanggal){
    context = _context;
  }
}

class LoadMoreEvent extends ShiftKaryawanDetailEvent{
  late ScrollController scrollController;
  LoadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, ScrollController _scrollController){
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class ShiftKaryawanDetailState{
  List<DataShiftTeman>? data;
  DataShiftTeman? dataAktivitas;
}

class GetListShiftKaryawanDetailSuccessState extends ShiftKaryawanDetailState{
  GetListShiftKaryawanDetailSuccessState(ShiftKaryawanDetailEvent _event, List<DataShiftTeman>? _data){
    data = _data;
  }
}

class ShiftKaryawanDetailProgressState extends ShiftKaryawanDetailState{}

class LoadMoreProgressState extends ShiftKaryawanDetailState{
  LoadMoreProgressState(List<DataShiftTeman>? _data){
    data = _data;
  }
}

class ShiftKaryawanDetailErrorState extends ShiftKaryawanDetailState{}

class ShiftKaryawanDetailBloc extends Bloc<ShiftKaryawanDetailEvent, ShiftKaryawanDetailState>{
  ShiftKaryawanDetailState? initialState;
  List<DataShiftTeman>? listShiftTeman;
  ModelFilter? modelFilter;
  String? idMasterShift;
  String? tanggal;
  int offset = 0;
  int limit = ServerInfo.limit;

  ShiftKaryawanDetailBloc(ShiftKaryawanDetailState initialState) : super(initialState);

  @override
  Stream<ShiftKaryawanDetailState> mapEventToState(ShiftKaryawanDetailEvent event) async*{
    // TODO: implement mapEventToState
    if(event is GetListShiftKaryawanDetailEvent){
      offset = 0;
      modelFilter = event.modelFilter;
      idMasterShift = event.idMasterShift;
      tanggal = event.tanggal;
      yield ShiftKaryawanDetailProgressState();
      ShiftTemanKaryawanRespon shiftKaryawanRespon = await ShiftApi().getDataShiftKaryawanDetail(offset, modelFilter, idMasterShift, tanggal);
      if(shiftKaryawanRespon.success!){
        listShiftTeman = shiftKaryawanRespon.data;
        yield GetListShiftKaryawanDetailSuccessState(event, listShiftTeman);
      }
      else yield ShiftKaryawanDetailErrorState();
    }
    else if(event is LoadMoreEvent){
      if (event.scrollController.offset >=
          event.scrollController.position.maxScrollExtent &&
          !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listShiftTeman);
        ShiftTemanKaryawanRespon shiftTemanRespon = await ShiftApi().getDataShiftTemanDetail(offset, modelFilter, idMasterShift, tanggal);
        if(shiftTemanRespon.success!){
          listShiftTeman!.addAll(shiftTemanRespon.data!);
        }
        yield GetListShiftKaryawanDetailSuccessState(event, listShiftTeman);
      }
    }
  }
}