import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataLayananDetailBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/DataLayananDetailByIdBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/KambanBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TotalDataLayananDetailBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TotalKambanBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayananDetail.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayanan.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataProduct.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/SalesActivityApi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:bloc/bloc.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:sn_progress_dialog/sn_progress_dialog.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart' as customFunction;

abstract class LayananDraftEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

class getListLayananDraftEvent extends LayananDraftEvent {
  ModelFilter? modelFilter;
  getListLayananDraftEvent(BuildContext _context, this.modelFilter) {
    context = _context;
  }
}

class addLayananDraftEvent extends LayananDraftEvent {
  DataProduct? dataProduct;
  addLayananDraftEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, this.dataProduct) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class addLayananEvent extends LayananDraftEvent {
  DataProduct? dataProduct;
  String? idPipelineMain;
  String? idTahapan;
  addLayananEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, this.dataProduct, this.idPipelineMain, this.idTahapan) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class deleteLayananDraftEvent extends LayananDraftEvent {
  Layanan? dataProduct;
  deleteLayananDraftEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, this.dataProduct) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class deleteLayananEvent extends LayananDraftEvent {
  BuildContext? context;
  Layanan? dataProduct;
  bool? bottomSheet;
  deleteLayananEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, this.dataProduct, this.bottomSheet) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class editLayananDraftEvent extends LayananDraftEvent {
  DataProduct? dataProduct;
  String? idPipelineLayananDraft;
  String? idKaryawan;
  String? idCompany;
  editLayananDraftEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, this.dataProduct, this.idPipelineLayananDraft, this.idKaryawan, this.idCompany) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class editLayananEvent extends LayananDraftEvent {
  DataProduct? dataProduct;
  String? idPipelineMain;
  String? idPipelineLayanan;
  bool? bottomSheet;
  String? page;
  editLayananEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, this.dataProduct, this.idPipelineMain, this.idPipelineLayanan, this.bottomSheet, this.page) {
    context = _context;
    scaffoldKey = _scaffoldKey;
  }
}

class loadMoreEvent extends LayananDraftEvent {
  late ScrollController scrollController;
  loadMoreEvent(BuildContext _context, GlobalKey<ScaffoldState> _scaffoldKey, ScrollController _scrollController) {
    context = _context;
    scaffoldKey = _scaffoldKey;
    scrollController = _scrollController;
  }
}

abstract class LayananDraftState {
  int? totalLayanan;
  String? totalHarga;
  List<Layanan>? data;
  Layanan? dataDetail;
}

class getListLayananDraftSuccessState extends LayananDraftState {
  getListLayananDraftSuccessState(LayananDraftEvent _event, List<Layanan>? _data, int? _totalLayanan, String? _totalHarga) {
    data = _data;
    totalLayanan = _totalLayanan;
    totalHarga = _totalHarga;
  }
}

class LayananDraftProgressState extends LayananDraftState {}

class LoadMoreProgressState extends LayananDraftState {
  LoadMoreProgressState(List<Layanan>? _data) {
    data = _data;
  }
}

class LayananDraftErrorState extends LayananDraftState {}

class LayananDraftBloc extends Bloc<LayananDraftEvent, LayananDraftState> {
  ModelFilter? modelFilter;
  LayananDraftState? initialState;
  int? totalLayanan;
  String? totalHarga;
  List<Layanan>? listDataLayanan;
  int offset = 0;
  int limit = ServerInfo.limit;

  LayananDraftBloc(LayananDraftState initialState) : super(initialState);

  @override
  Stream<LayananDraftState> mapEventToState(LayananDraftEvent event) async* {
    if (event is getListLayananDraftEvent) {
      offset = 0;
      modelFilter = event.modelFilter;
      yield LayananDraftProgressState();
      DataLayananRespon dataLayananRespon = await SalesActivityApi().getDataLayanan(offset, modelFilter);
      if (dataLayananRespon.success!) {
        totalLayanan = dataLayananRespon.dataLayanan!.totalLayanan;
        totalHarga = dataLayananRespon.dataLayanan!.totalHarga;
        listDataLayanan = dataLayananRespon.dataLayanan!.data;
        yield getListLayananDraftSuccessState(event, listDataLayanan, totalLayanan, totalHarga);
      } else
        yield LayananDraftErrorState();
    } else if (event is loadMoreEvent) {
      if (event.scrollController.offset >= event.scrollController.position.maxScrollExtent && !event.scrollController.position.outOfRange) {
        offset = offset + limit;
        yield LoadMoreProgressState(listDataLayanan);
        DataLayananRespon dataLayananRespon = await SalesActivityApi().getDataLayanan(offset, modelFilter);
        if (dataLayananRespon.success!) {
          listDataLayanan!.addAll(dataLayananRespon.dataLayanan!.data!);
        }
        yield getListLayananDraftSuccessState(event, listDataLayanan, totalLayanan, totalHarga);
      }
    } else if(event is addLayananDraftEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      DataProductRespon dtp = await SalesActivityApi().addLayananDraft(event.dataProduct!);
      ProgressDialogDelayed.hide(pd);
      if (dtp.success!) {
        // customFunction.CustomPopUp.show(dtp.message, event.context, "Tutup", isDismissible: false, doublePop: true);
        BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
        showSnackBarDelayed(event.scaffoldKey, dtp.message, event.context);
        BlocProvider.of<LayananDraftBloc>(event.context!)
            .add(getListLayananDraftEvent(event.context!, ModelFilter(monthYear: DateTime.now())));
      }
    }
    else if(event is deleteLayananDraftEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      DataProductRespon dtp = await SalesActivityApi().deleteLayananDraft(event.dataProduct!);
      ProgressDialogDelayed.hide(pd);
      if (dtp.success!) {
        // customFunction.CustomPopUp.show(dtp.message, event.context, "Tutup", isDismissible: false);
        BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
        showSnackBarDelayed(event.scaffoldKey, dtp.message, event.context);
        BlocProvider.of<LayananDraftBloc>(event.context!)
            .add(getListLayananDraftEvent(event.context!, ModelFilter(monthYear: DateTime.now())));
      }
    }
    else if(event is addLayananEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      DataProductRespon dtp = await SalesActivityApi().addLayanan(event.dataProduct!, event.idPipelineMain!);
      ProgressDialogDelayed.hide(pd);
      if (dtp.success!) {
        // customFunction.CustomPopUp.show(dtp.message, event.context, "Tutup", isDismissible: false, doublePop: true);
        BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
        showSnackBarDelayed(event.scaffoldKey, dtp.message, event.context);
        BlocProvider.of<TotalDataLayananDetailBloc>(event.context!).add(getTotalDataLayananDetailEvent(event.context!, event.idPipelineMain));
        BlocProvider.of<DataLayananDetailBloc>(event.context!).add(getDataLayananDetailEvent(event.context!, event.idPipelineMain));
        BlocProvider.of<TotalKambanBloc>(event.context!).add(getTotalKambanEvent(event.context!, event.idTahapan, ModelFilter(monthYear: DateTime.now())));
        BlocProvider.of<KambanBloc>(event.context!).add(getListDataKambanEvent(event.context!, event.idTahapan, ModelFilter(monthYear: DateTime.now())));
      }
    }
    else if(event is deleteLayananEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      BasicRespon dtp = await SalesActivityApi().deleteLayanan(event.dataProduct!);
      ProgressDialogDelayed.hide(pd);
      if (dtp.success!) {
        BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
        showSnackBarDelayed(event.scaffoldKey, dtp.message, event.context);
        // customFunction.CustomPopUp.show(dtp.message, event.context!, "Tutup", isDismissible: false);
        if(event.bottomSheet!){
          BlocProvider.of<DataLayananDetailByIdBloc>(event.context!).add(getDataLayananDetailByIdEvent(event.context!, event.dataProduct!.idPipelineMain));
        }else{
          BlocProvider.of<TotalDataLayananDetailBloc>(event.context!).add(getTotalDataLayananDetailEvent(event.context!, event.dataProduct!.idPipelineMain));
          BlocProvider.of<DataLayananDetailBloc>(event.context!).add(getDataLayananDetailEvent(event.context!, event.dataProduct!.idPipelineMain));
        }
      }else{
        showSnackBarDelayed(event.scaffoldKey, dtp.message, event.context);
      }
    }
    else if(event is editLayananDraftEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: true);
      BasicRespon dtp = await SalesActivityApi().editLayananDraft(event.dataProduct!, event.idPipelineLayananDraft!, event.idKaryawan!, event.idCompany!);
      ProgressDialogDelayed.hide(pd);
      if (dtp.success!) {
        // customFunction.CustomPopUp.show(dtp.message, event.context, "Tutup", isDismissible: false, doublePop: true);
        BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
        showSnackBarDelayed(event.scaffoldKey, dtp.message, event.context);
        BlocProvider.of<LayananDraftBloc>(event.context!)
            .add(getListLayananDraftEvent(event.context!, ModelFilter(monthYear: DateTime.now())));
      }else{
        BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
        showSnackBarDelayed(event.scaffoldKey, dtp.message, event.context);
      }
    }
    else if(event is editLayananEvent){
      ProgressDialog pd = ProgressDialog(context: event.context);
      ProgressDialogDelayed.show(pd, isDismissible: false);
      DataProductRespon dtp = await SalesActivityApi().editLayanan(event.dataProduct!, event.idPipelineMain!, event.idPipelineLayanan!);
      ProgressDialogDelayed.hide(pd);
      if (dtp.success!) {
        // customFunction.CustomPopUp.show(dtp.message, event.context, "Tutup", isDismissible: false, doublePop: true);
        BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
        showSnackBarDelayed(event.scaffoldKey, dtp.message, event.context);
        // if(event.page == 'detail'){
          if(event.bottomSheet!){
            BlocProvider.of<DataLayananDetailByIdBloc>(event.context!).add(getDataLayananDetailByIdEvent(event.context!, event.idPipelineMain));
          }else{
            BlocProvider.of<TotalDataLayananDetailBloc>(event.context!).add(getTotalDataLayananDetailEvent(event.context!, event.idPipelineMain));
            BlocProvider.of<DataLayananDetailBloc>(event.context!).add(getDataLayananDetailEvent(event.context!, event.idPipelineMain));
          }
        // }else{
        //   BlocProvider.of<TotalDataLayananDetailBloc>(event.context!).add(getTotalDataLayananDetailEvent(event.context!, event.idPipelineMain));
        //   BlocProvider.of<DataLayananDetailBloc>(event.context!).add(getDataLayananDetailEvent(event.context!, event.idPipelineMain));
        // }


        // BlocProvider.of<TotalKambanBloc>(event.context!).add(getTotalKambanEvent(event.context!, event.idTahapan, ModelFilter(monthYear: DateTime.now())));
        // BlocProvider.of<KambanBloc>(event.context!).add(getListDataKambanEvent(event.context!, event.idTahapan, ModelFilter(monthYear: DateTime.now())));
      }else{
        BlocProvider.of<NavigatorBloc>(event.context!).add(NavigatePop(event.context));
        showSnackBarDelayed(event.scaffoldKey, dtp.message, event.context);
      }
    }
  }
}
